/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.network;

import java.util.HashMap;
import net.mcreator.astraldimension.AstralDimensionMod;
import net.mcreator.astraldimension.procedures.BrickPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.FlakePatternApplyProcedure;
import net.mcreator.astraldimension.procedures.FlowerPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.MetalPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.PillarPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.PortalPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.PresentPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.WindowPatternApplyProcedure;
import net.mcreator.astraldimension.world.inventory.AstraniteCauldronGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record AstraniteCauldronGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AstraniteCauldronGUIButtonMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("astral_dimension", "astranite_cauldron_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AstraniteCauldronGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new AstraniteCauldronGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<AstraniteCauldronGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(AstraniteCauldronGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                AstraniteCauldronGUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = AstraniteCauldronGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            FlowerPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            PortalPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            PillarPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            PresentPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            FlakePatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            MetalPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            BrickPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            WindowPatternApplyProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AstralDimensionMod.addNetworkMessage(TYPE, STREAM_CODEC, AstraniteCauldronGUIButtonMessage::handleData);
    }
}

