/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.entity;

import java.util.EnumSet;
import net.mcreator.astraldimension.init.AstralDimensionModEntities;
import net.mcreator.astraldimension.procedures.SolarHornetOnEntityTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SolarHornetEntity
extends Monster
implements IAnimatable {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(SolarHornetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(SolarHornetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(SolarHornetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";

    public SolarHornetEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SolarHornetEntity>)((EntityType)AstralDimensionModEntities.SOLAR_HORNET.get()), world);
    }

    public SolarHornetEntity(EntityType<SolarHornetEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 3;
        this.m_21557_(false);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"solar_hornet");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                return SolarHornetEntity.this.m_5448_() != null && !SolarHornetEntity.this.m_21566_().m_24995_();
            }

            public boolean m_8045_() {
                return SolarHornetEntity.this.m_21566_().m_24995_() && SolarHornetEntity.this.m_5448_() != null && SolarHornetEntity.this.m_5448_().m_6084_();
            }

            public void m_8056_() {
                LivingEntity livingentity = SolarHornetEntity.this.m_5448_();
                Vec3 vec3d = livingentity.m_20299_(1.0f);
                SolarHornetEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
            }

            public void m_8037_() {
                LivingEntity livingentity = SolarHornetEntity.this.m_5448_();
                if (SolarHornetEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    SolarHornetEntity.this.m_7327_((Entity)livingentity);
                } else {
                    double d0 = SolarHornetEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.m_20299_(1.0f);
                        SolarHornetEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 m_7037_() {
                RandomSource random = SolarHornetEntity.this.m_217043_();
                double dir_x = SolarHornetEntity.this.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double dir_y = SolarHornetEntity.this.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double dir_z = SolarHornetEntity.this.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("astral_dimension:solar_hornet_buzzes"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("astral_dimension:solar_hornet_hurts"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("astral_dimension:solar_hornet_dies"));
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        SolarHornetOnEntityTickUpdateProcedure.execute((Entity)this);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 40.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.5);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 28.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.5);
        builder = builder.m_22268_(Attributes.f_22282_, 0.1);
        builder = builder.m_22268_(Attributes.f_22280_, 0.3);
        return builder;
    }

    private <E extends IAnimatable> PlayState movementPredicate(AnimationEvent<E> event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.m_21224_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.solar_hornet.dies", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                return PlayState.CONTINUE;
            }
            if (!this.m_20096_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.solar_hornet.flying", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.solar_hornet.flying", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState attackingPredicate(AnimationEvent<E> event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.f_19853_.m_46467_();
        }
        if (this.swinging && this.lastSwing + 15L <= this.f_19853_.m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.solar_hornet.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState procedurePredicate(AnimationEvent<E> event) {
        SolarHornetEntity entity = this;
        Level world = ((Entity)entity).f_19853_;
        boolean loop = false;
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!loop && this.lastloop) {
            this.lastloop = false;
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            event.getController().clearAnimationCache();
            return PlayState.STOP;
        }
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            if (!loop) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
                    this.animationprocedure = "empty";
                    event.getController().markNeedsReload();
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                this.lastloop = true;
            }
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement", 4.0f, this::movementPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attacking", 4.0f, this::attackingPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "procedure", 4.0f, this::procedurePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

