/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.astraldimension.AstralDimensionMod;
import net.mcreator.astraldimension.procedures.BrickPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.FlakePatternApplyProcedure;
import net.mcreator.astraldimension.procedures.FlowerPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.MetalPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.PillarPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.PortalPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.PresentPatternApplyProcedure;
import net.mcreator.astraldimension.procedures.WindowPatternApplyProcedure;
import net.mcreator.astraldimension.world.inventory.AstraniteCauldronGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AstraniteCauldronGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public AstraniteCauldronGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public AstraniteCauldronGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(AstraniteCauldronGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(AstraniteCauldronGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            AstraniteCauldronGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = AstraniteCauldronGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            FlowerPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            PortalPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            PillarPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            PresentPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            BrickPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            FlakePatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            MetalPatternApplyProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            WindowPatternApplyProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AstralDimensionMod.addNetworkMessage(AstraniteCauldronGUIButtonMessage.class, AstraniteCauldronGUIButtonMessage::buffer, AstraniteCauldronGUIButtonMessage::new, AstraniteCauldronGUIButtonMessage::handler);
    }
}

