/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins;

import com.brandonitaly.bedrockskins.BedrockSkinsNetworking;
import com.brandonitaly.bedrockskins.PlayerSkinData;
import com.brandonitaly.bedrockskins.ServerSkinManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BedrockSkins
implements ModInitializer {
    private final Logger logger = LoggerFactory.getLogger((String)"bedrockskins");
    private final Map<UUID, Long> lastSkinChange = new HashMap<UUID, Long>();

    public void onInitialize() {
        this.logger.info("Initializing Bedrock Skins Mod");
        PayloadTypeRegistry.playS2C().register(BedrockSkinsNetworking.SkinUpdatePayload.ID, BedrockSkinsNetworking.SkinUpdatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(BedrockSkinsNetworking.SetSkinPayload.ID, BedrockSkinsNetworking.SetSkinPayload.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ServerSkinManager.getAllSkins().forEach((uuid, skinData) -> ServerPlayNetworking.send((class_3222)handler.field_14140, (class_8710)new BedrockSkinsNetworking.SkinUpdatePayload((UUID)uuid, skinData.skinKey, skinData.geometry, skinData.textureData))));
        ServerPlayNetworking.registerGlobalReceiver(BedrockSkinsNetworking.SetSkinPayload.ID, (payload, context) -> {
            String skinKey = payload.getSkinKey();
            class_3222 player = context.player();
            UUID uuid = player.method_5667();
            MinecraftServer server = context.server();
            String geometry = payload.getGeometry();
            byte[] textureData = payload.getTextureData();
            server.execute(() -> {
                long now = System.currentTimeMillis();
                Long last = this.lastSkinChange.get(uuid);
                if (last != null && now - last < 5000L) {
                    this.logger.warn("Player {} is changing skins too quickly.", (Object)player.method_5477().getString());
                    return;
                }
                if (!"RESET".equals(skinKey)) {
                    if (textureData.length > 524288) {
                        this.logger.warn("Player {} sent oversized texture ({} bytes).", (Object)player.method_5477().getString(), (Object)textureData.length);
                        return;
                    }
                    if (textureData.length < 8 || textureData[0] != -119 || textureData[1] != 80 || textureData[2] != 78 || textureData[3] != 71) {
                        this.logger.warn("Player {} sent invalid texture format (not PNG).", (Object)player.method_5477().getString());
                        return;
                    }
                    if (geometry.length() > 100000) {
                        this.logger.warn("Player {} sent oversized geometry ({} chars).", (Object)player.method_5477().getString(), (Object)geometry.length());
                        return;
                    }
                }
                this.logger.info("Player {} set skin to {}", (Object)player.method_5477().getString(), (Object)skinKey);
                if ("RESET".equals(skinKey)) {
                    ServerSkinManager.removeSkin(uuid);
                } else {
                    PlayerSkinData data = new PlayerSkinData(skinKey, geometry, textureData);
                    ServerSkinManager.setSkin(uuid, data);
                }
                BedrockSkinsNetworking.SkinUpdatePayload updatePayload = new BedrockSkinsNetworking.SkinUpdatePayload(uuid, skinKey, geometry, textureData);
                server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)updatePayload));
            });
        });
    }
}

