/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins;

import java.util.Arrays;
import java.util.Objects;

public class PlayerSkinData {
    public final String skinKey;
    public final String geometry;
    public final byte[] textureData;

    public PlayerSkinData(String skinKey, String geometry, byte[] textureData) {
        this.skinKey = skinKey;
        this.geometry = geometry;
        this.textureData = textureData == null ? new byte[]{} : textureData;
    }

    public String getSkinKey() {
        return this.skinKey;
    }

    public String getGeometry() {
        return this.geometry;
    }

    public byte[] getTextureData() {
        return this.textureData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerSkinData that = (PlayerSkinData)o;
        if (!Objects.equals(this.skinKey, that.skinKey)) {
            return false;
        }
        if (!Objects.equals(this.geometry, that.geometry)) {
            return false;
        }
        return Arrays.equals(this.textureData, that.textureData);
    }

    public int hashCode() {
        int result = Objects.hash(this.skinKey, this.geometry);
        result = 31 * result + Arrays.hashCode(this.textureData);
        return result;
    }
}

