/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins.client;

import com.brandonitaly.bedrockskins.bedrock.BedrockFile;
import com.brandonitaly.bedrockskins.bedrock.BedrockGeometry;
import com.brandonitaly.bedrockskins.client.BedrockPlayerModel;
import com.brandonitaly.bedrockskins.client.SkinManager;
import com.brandonitaly.bedrockskins.pack.LoadedSkin;
import com.brandonitaly.bedrockskins.pack.SkinPackLoader;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class BedrockModelManager {
    private static final Map<UUID, BedrockPlayerModel> bedrockModels = new HashMap<UUID, BedrockPlayerModel>();
    private static final Map<UUID, String> activeSkinKeys = new HashMap<UUID, String>();
    private static final Gson gson = new Gson();

    private BedrockModelManager() {
    }

    public static BedrockPlayerModel getModel(UUID uuid) {
        String skinKey = SkinManager.getSkin(uuid.toString());
        if (skinKey == null) {
            return null;
        }
        if (!skinKey.equals(activeSkinKeys.get(uuid))) {
            bedrockModels.remove(uuid);
            activeSkinKeys.put(uuid, skinKey);
        }
        if (bedrockModels.containsKey(uuid)) {
            return bedrockModels.get(uuid);
        }
        LoadedSkin skin = SkinPackLoader.loadedSkins.get(skinKey);
        if (skin == null) {
            return null;
        }
        try {
            SkinPackLoader.registerTextureFor(skinKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            BedrockFile bedrockFile = (BedrockFile)gson.fromJson((JsonElement)skin.geometryData, BedrockFile.class);
            List<BedrockGeometry> geometryList = bedrockFile.getGeometries();
            if (geometryList != null && !geometryList.isEmpty()) {
                BedrockGeometry geometry = geometryList.get(0);
                BedrockPlayerModel model = BedrockPlayerModel.create(geometry, false);
                bedrockModels.put(uuid, model);
                return model;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void clearAllModels() {
        bedrockModels.clear();
        activeSkinKeys.clear();
    }
}

