/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins.client;

import com.brandonitaly.bedrockskins.bedrock.BedrockBone;
import com.brandonitaly.bedrockskins.bedrock.BedrockCube;
import com.brandonitaly.bedrockskins.bedrock.BedrockGeometry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_10055;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_591;
import net.minecraft.class_630;

public class BedrockPlayerModel
extends class_591 {
    public final class_630 root;
    public final Map<String, class_630> partsMap;
    public final Map<String, PartTransform> defaultTransforms;
    public float armorYOffset = 0.0f;
    public float capeYOffset = 0.0f;
    public float upperArmorYOffset = 0.0f;
    private final boolean animationArmsOutFront;
    private final boolean animationStationaryLegs;

    public BedrockPlayerModel(class_630 root, boolean thinArms, Map<String, class_630> partsMap, Map<String, PartTransform> defaultTransforms, boolean animationArmsOutFront, boolean animationStationaryLegs) {
        super(root, thinArms);
        this.root = root;
        this.partsMap = Collections.unmodifiableMap(new HashMap<String, class_630>(partsMap));
        this.defaultTransforms = Collections.unmodifiableMap(new HashMap<String, PartTransform>(defaultTransforms));
        this.animationArmsOutFront = animationArmsOutFront;
        this.animationStationaryLegs = animationStationaryLegs;
    }

    public static BedrockPlayerModel create(BedrockGeometry geometry, boolean thinArms) {
        BedrockPlayerModel.validateAndPatchGeometry(geometry);
        BuildRootResult res = BedrockPlayerModel.buildRoot(geometry);
        return new BedrockPlayerModel(res.root, thinArms, res.parts, res.defaults, geometry.getAnimationArmsOutFront() != null ? geometry.getAnimationArmsOutFront() : false, geometry.getAnimationStationaryLegs() != null ? geometry.getAnimationStationaryLegs() : false);
    }

    private static void validateAndPatchGeometry(BedrockGeometry geometry) {
        HashMap<String, String> requiredBones = new HashMap<String, String>();
        requiredBones.put("head", "body");
        requiredBones.put("hat", "head");
        requiredBones.put("body", null);
        requiredBones.put("jacket", "body");
        requiredBones.put("leftArm", "body");
        requiredBones.put("leftSleeve", "leftArm");
        requiredBones.put("rightArm", "body");
        requiredBones.put("rightSleeve", "rightArm");
        requiredBones.put("leftLeg", "body");
        requiredBones.put("leftPants", "leftLeg");
        requiredBones.put("rightLeg", "body");
        requiredBones.put("rightPants", "rightLeg");
        ArrayList<BedrockBone> currentBones = geometry.getBones() != null ? new ArrayList<BedrockBone>(geometry.getBones()) : new ArrayList();
        HashSet<String> existingBoneNames = new HashSet<String>();
        for (BedrockBone bedrockBone : currentBones) {
            if (bedrockBone.getName() == null) continue;
            existingBoneNames.add(bedrockBone.getName().toLowerCase());
        }
        ArrayList<BedrockBone> newBones = new ArrayList<BedrockBone>();
        for (Map.Entry entry : requiredBones.entrySet()) {
            String boneName = (String)entry.getKey();
            String parentName = (String)entry.getValue();
            boolean isMissing = !existingBoneNames.contains(boneName.toLowerCase()) && !existingBoneNames.contains(BedrockPlayerModel.mapBoneName(boneName).toLowerCase());
            if (!isMissing) continue;
            BedrockBone b = new BedrockBone();
            b.setName(boneName);
            b.setParent(parentName);
            b.setPivot(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
            b.setRotation(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
            b.setCubes(Collections.emptyList());
            b.setMirror(false);
            newBones.add(b);
        }
        if (!newBones.isEmpty()) {
            ArrayList<BedrockBone> arrayList = new ArrayList<BedrockBone>(currentBones);
            arrayList.addAll(newBones);
            geometry.setBones(arrayList);
        }
    }

    private static BuildRootResult buildRoot(BedrockGeometry geometry) {
        class_5609 modelData = new class_5609();
        class_5610 rootData = modelData.method_32111();
        HashMap<String, BedrockBone> boneMap = new HashMap<String, BedrockBone>();
        if (geometry.getBones() != null) {
            for (BedrockBone bedrockBone : geometry.getBones()) {
                boneMap.put(bedrockBone.getName(), bedrockBone);
            }
        }
        HashSet<String> processedBones = new HashSet<String>();
        if (geometry.getBones() != null) {
            for (BedrockBone b : geometry.getBones()) {
                BedrockPlayerModel.addBoneRecursively(b.getName(), boneMap, processedBones);
            }
        }
        HashMap<String, class_5610> hashMap = new HashMap<String, class_5610>();
        HashSet<String> vanillaRootParts = new HashSet<String>(Arrays.asList("head", "body", "right_arm", "left_arm", "right_leg", "left_leg"));
        ArrayList<BedrockBone> bonesToProcess = geometry.getBones() != null ? new ArrayList<BedrockBone>(geometry.getBones()) : new ArrayList();
        HashMap<String, PartTransform> defaultTransforms = new HashMap<String, PartTransform>();
        int stuckCounter = 0;
        while (!bonesToProcess.isEmpty()) {
            Iterator iterator = bonesToProcess.iterator();
            boolean processedAny = false;
            while (iterator.hasNext()) {
                class_5610 parentForCreation;
                BedrockBone bone = (BedrockBone)iterator.next();
                if (bone.getParent() != null && !hashMap.containsKey(bone.getParent())) continue;
                class_5610 parentData = bone.getParent() == null ? rootData : (class_5610)hashMap.get(bone.getParent());
                class_5606 builder = class_5606.method_32108();
                if (bone.getCubes() != null) {
                    for (BedrockCube cube : bone.getCubes()) {
                        float dilation;
                        Map map;
                        List uvList;
                        int u = 0;
                        int v = 0;
                        Object uvObj = cube.getUv();
                        if (uvObj instanceof List) {
                            List list = (List)uvObj;
                            if (list.size() >= 2) {
                                u = ((Number)list.get(0)).intValue();
                                v = ((Number)list.get(1)).intValue();
                            }
                        } else if (uvObj instanceof Map && (uvList = (List)(map = (Map)uvObj).get("uv")) != null && uvList.size() >= 2) {
                            u = ((Number)uvList.get(0)).intValue();
                            v = ((Number)uvList.get(1)).intValue();
                        }
                        float f = dilation = cube.getInflate() != null ? cube.getInflate().floatValue() : 0.0f;
                        boolean isMirrored = cube.getMirror() != null ? cube.getMirror() : (bone.getMirror() != null ? bone.getMirror() : false);
                        float bPx = bone.getPivot() != null && bone.getPivot().size() > 0 ? bone.getPivot().get(0).floatValue() : 0.0f;
                        float bPy = bone.getPivot() != null && bone.getPivot().size() > 1 ? bone.getPivot().get(1).floatValue() : 0.0f;
                        float bPz = bone.getPivot() != null && bone.getPivot().size() > 2 ? bone.getPivot().get(2).floatValue() : 0.0f;
                        float cOx = cube.getOrigin().get(0).floatValue();
                        float cOy = cube.getOrigin().get(1).floatValue();
                        float cOz = cube.getOrigin().get(2).floatValue();
                        float offX = cOx - bPx;
                        float offY = bPy - cOy - cube.getSize().get(1).floatValue();
                        float offZ = cOz - bPz;
                        builder.method_32106(isMirrored).method_32101(u, v).method_32098(offX, offY, offZ, cube.getSize().get(0).floatValue(), cube.getSize().get(1).floatValue(), cube.getSize().get(2).floatValue(), new class_5605(dilation));
                    }
                }
                float bPx = bone.getPivot() != null && bone.getPivot().size() > 0 ? bone.getPivot().get(0).floatValue() : 0.0f;
                float bPy = bone.getPivot() != null && bone.getPivot().size() > 1 ? bone.getPivot().get(1).floatValue() : 0.0f;
                float bPz = bone.getPivot() != null && bone.getPivot().size() > 2 ? bone.getPivot().get(2).floatValue() : 0.0f;
                float pX = bPx;
                float pY = 24.0f - bPy;
                float pZ = bPz;
                String vanillaName = BedrockPlayerModel.mapBoneName(bone.getName());
                class_5610 class_56102 = parentForCreation = bone.getParent() != null && vanillaRootParts.contains(vanillaName) ? rootData : parentData;
                if (bone.getParent() != null && parentForCreation != rootData) {
                    BedrockBone parentBone = (BedrockBone)boneMap.get(bone.getParent());
                    float ppX = parentBone.getPivot() != null && parentBone.getPivot().size() > 0 ? parentBone.getPivot().get(0).floatValue() : 0.0f;
                    float ppY = parentBone.getPivot() != null && parentBone.getPivot().size() > 1 ? 24.0f - parentBone.getPivot().get(1).floatValue() : 24.0f;
                    float ppZ = parentBone.getPivot() != null && parentBone.getPivot().size() > 2 ? parentBone.getPivot().get(2).floatValue() : 0.0f;
                    pX -= ppX;
                    pY -= ppY;
                    pZ -= ppZ;
                }
                float rotX = (float)Math.toRadians(-(bone.getRotation() != null && bone.getRotation().size() > 0 ? bone.getRotation().get(0).floatValue() : 0.0f));
                float rotY = (float)Math.toRadians(-(bone.getRotation() != null && bone.getRotation().size() > 1 ? bone.getRotation().get(1).floatValue() : 0.0f));
                float rotZ = (float)Math.toRadians(bone.getRotation() != null && bone.getRotation().size() > 2 ? bone.getRotation().get(2).floatValue() : 0.0f);
                class_5603 transform = class_5603.method_32091((float)pX, (float)pY, (float)pZ, (float)rotX, (float)rotY, (float)rotZ);
                class_5610 partData = parentForCreation.method_32117(vanillaName, builder, transform);
                hashMap.put(bone.getName(), partData);
                defaultTransforms.put(bone.getName(), new PartTransform(pX, pY, pZ, rotX, rotY, rotZ));
                if (!vanillaName.equals(bone.getName())) {
                    defaultTransforms.put(vanillaName, new PartTransform(pX, pY, pZ, rotX, rotY, rotZ));
                }
                iterator.remove();
                processedAny = true;
            }
            if (processedAny || ++stuckCounter <= 5) continue;
            break;
        }
        class_5607 texturedModelData = class_5607.method_32110((class_5609)modelData, (int)geometry.getDescription().getTextureWidth(), (int)geometry.getDescription().getTextureHeight());
        class_630 rootPart = texturedModelData.method_32109();
        HashMap<String, class_630> finalParts = new HashMap<String, class_630>();
        for (String name : boneMap.keySet()) {
            class_630 found = BedrockPlayerModel.findPart(rootPart, name, boneMap);
            if (found == null) continue;
            finalParts.put(name, found);
        }
        return new BuildRootResult(rootPart, finalParts, defaultTransforms);
    }

    private static class_630 findPart(class_630 parent, String boneName, Map<String, BedrockBone> boneMap) {
        BedrockBone bone = boneMap.get(boneName);
        if (bone == null) {
            return null;
        }
        String mappedRootName = BedrockPlayerModel.mapBoneName(bone.getName());
        if (parent.method_41919(mappedRootName)) {
            return parent.method_32086(mappedRootName);
        }
        ArrayList<String> path = new ArrayList<String>();
        BedrockBone curr = bone;
        while (curr != null) {
            path.add(BedrockPlayerModel.mapBoneName(curr.getName()));
            String p = curr.getParent();
            curr = p != null ? boneMap.get(p) : null;
        }
        Collections.reverse(path);
        class_630 currPart = parent;
        for (String segment : path) {
            if (currPart.method_41919(segment)) {
                currPart = currPart.method_32086(segment);
                continue;
            }
            return null;
        }
        return currPart;
    }

    private static void addBoneRecursively(String boneName, Map<String, BedrockBone> boneMap, Set<String> processedBones) {
        if (!processedBones.add(boneName)) {
            return;
        }
        BedrockBone bone = boneMap.get(boneName);
        if (bone == null) {
            return;
        }
        if (bone.getParent() != null) {
            BedrockPlayerModel.addBoneRecursively(bone.getParent(), boneMap, processedBones);
        }
    }

    public static String mapBoneName(String name) {
        String lower;
        switch (lower = name.toLowerCase()) {
            case "head": {
                return "head";
            }
            case "hat": 
            case "headwear": {
                return "hat";
            }
            case "body": {
                return "body";
            }
            case "jacket": {
                return "jacket";
            }
            case "rightarm": 
            case "right_arm": {
                return "right_arm";
            }
            case "leftarm": 
            case "left_arm": {
                return "left_arm";
            }
            case "rightleg": 
            case "right_leg": {
                return "right_leg";
            }
            case "leftleg": 
            case "left_leg": {
                return "left_leg";
            }
            case "rightsleeve": 
            case "right_sleeve": {
                return "right_sleeve";
            }
            case "leftsleeve": 
            case "left_sleeve": {
                return "left_sleeve";
            }
            case "rightpants": 
            case "right_pants": {
                return "right_pants";
            }
            case "leftpants": 
            case "left_pants": {
                return "left_pants";
            }
        }
        return name;
    }

    public void setBedrockPartVisible(String partName, boolean visible) {
        class_630 p = this.partsMap.get(partName);
        if (p != null) {
            p.field_3665 = visible;
        }
    }

    public void method_62110(class_10055 state) {
        super.method_62110(state);
        if (this.animationArmsOutFront) {
            this.setArmAngle(this.partsMap.getOrDefault("rightArm", this.partsMap.get("right_arm")));
            this.setArmAngle(this.partsMap.getOrDefault("leftArm", this.partsMap.get("left_arm")));
        }
        if (this.animationStationaryLegs) {
            this.resetLegAngle("rightLeg", "right_leg");
            this.resetLegAngle("leftLeg", "left_leg");
        }
    }

    private void setArmAngle(class_630 part) {
        if (part == null) {
            return;
        }
        part.field_3654 = -1.5707964f;
        part.field_3675 = 0.0f;
        part.field_3674 = 0.0f;
    }

    private void resetLegAngle(String key1, String key2) {
        class_630 leg = this.partsMap.getOrDefault(key1, this.partsMap.get(key2));
        PartTransform def = this.defaultTransforms.getOrDefault(key1, this.defaultTransforms.get(key2));
        if (leg == null || def == null) {
            return;
        }
        leg.field_3654 = def.pitch;
        leg.field_3675 = def.yaw;
        leg.field_3674 = def.roll;
    }

    public void copyFromVanilla(class_591 vanillaModel) {
        class_630 dest;
        for (Object[] pair : Arrays.asList({"head", vanillaModel.field_3398}, {"body", vanillaModel.field_3391}, {"hat", vanillaModel.field_3394})) {
            String name = (String)pair[0];
            class_630 part2 = (class_630)pair[1];
            class_630 dest2 = this.partsMap.get(name);
            if (dest2 == null) {
                dest2 = this.partsMap.get(BedrockPlayerModel.mapBoneName(name));
            }
            if (dest2 == null) continue;
            dest2.field_3654 = part2.field_3654;
            dest2.field_3675 = part2.field_3675;
            dest2.field_3674 = part2.field_3674;
        }
        if (!this.animationArmsOutFront) {
            dest = this.partsMap.get("rightArm");
            if (dest != null) {
                dest.field_3654 = vanillaModel.field_3401.field_3654;
                dest.field_3675 = vanillaModel.field_3401.field_3675;
                dest.field_3674 = vanillaModel.field_3401.field_3674;
            }
            if ((dest = this.partsMap.get("leftArm")) != null) {
                dest.field_3654 = vanillaModel.field_27433.field_3654;
                dest.field_3675 = vanillaModel.field_27433.field_3675;
                dest.field_3674 = vanillaModel.field_27433.field_3674;
            }
        }
        if (!this.animationStationaryLegs) {
            dest = this.partsMap.get("rightLeg");
            if (dest != null) {
                dest.field_3654 = vanillaModel.field_3392.field_3654;
                dest.field_3675 = vanillaModel.field_3392.field_3675;
                dest.field_3674 = vanillaModel.field_3392.field_3674;
            }
            if ((dest = this.partsMap.get("leftLeg")) != null) {
                dest.field_3654 = vanillaModel.field_3397.field_3654;
                dest.field_3675 = vanillaModel.field_3397.field_3675;
                dest.field_3674 = vanillaModel.field_3397.field_3674;
            }
        }
        Function<class_630, Float> getPivotY = part -> {
            try {
                Field field = part.getClass().getDeclaredField("pivotY");
                field.setAccessible(true);
                Object f = field.get(part);
                if (f instanceof Number) {
                    return Float.valueOf(((Number)f).floatValue());
                }
                return Float.valueOf(0.0f);
            }
            catch (Exception ex) {
                try {
                    Field field = class_630.class.getDeclaredField("pivotY");
                    field.setAccessible(true);
                    return Float.valueOf(field.getFloat(part));
                }
                catch (Exception e) {
                    return Float.valueOf(0.0f);
                }
            }
        };
        try {
            PartTransform bodyTransform = this.defaultTransforms.getOrDefault("body", this.defaultTransforms.get("BODY"));
            float bedrockBodyY = bodyTransform != null ? bodyTransform.y : 0.0f;
            float vanillaBodyPivotY = getPivotY.apply(vanillaModel.field_3391).floatValue();
            float bedrockHeadY = this.defaultTransforms.getOrDefault("head", bodyTransform) != null ? this.defaultTransforms.getOrDefault((Object)"head", (PartTransform)bodyTransform).y : bedrockBodyY;
            float vanillaHeadPivotY = getPivotY.apply(vanillaModel.field_3398).floatValue();
            this.armorYOffset = this.upperArmorYOffset = (bedrockBodyY + bedrockHeadY) * 0.5f - (vanillaBodyPivotY + vanillaHeadPivotY) * 0.5f;
            PartTransform capeTransform = this.defaultTransforms.get("cape");
            float bedrockCapeY = capeTransform != null ? capeTransform.y : bedrockBodyY;
            this.capeYOffset = bedrockCapeY - vanillaBodyPivotY;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class BuildRootResult {
        final class_630 root;
        final Map<String, class_630> parts;
        final Map<String, PartTransform> defaults;

        BuildRootResult(class_630 root, Map<String, class_630> parts, Map<String, PartTransform> defaults) {
            this.root = root;
            this.parts = parts;
            this.defaults = defaults;
        }
    }

    public static class PartTransform {
        public final float x;
        public final float y;
        public final float z;
        public final float pitch;
        public final float yaw;
        public final float roll;

        public PartTransform(float x, float y, float z, float pitch, float yaw, float roll) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.pitch = pitch;
            this.yaw = yaw;
            this.roll = roll;
        }
    }
}

