/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins.client;

import com.brandonitaly.bedrockskins.BedrockSkinsNetworking;
import com.brandonitaly.bedrockskins.client.BedrockModelManager;
import com.brandonitaly.bedrockskins.client.BedrockSkinsState;
import com.brandonitaly.bedrockskins.client.FavoritesManager;
import com.brandonitaly.bedrockskins.client.SkinManager;
import com.brandonitaly.bedrockskins.client.StateManager;
import com.brandonitaly.bedrockskins.client.gui.SkinSelectionScreen;
import com.brandonitaly.bedrockskins.pack.AssetSource;
import com.brandonitaly.bedrockskins.pack.LoadedSkin;
import com.brandonitaly.bedrockskins.pack.SkinPackLoader;
import java.io.File;
import java.nio.file.Files;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1306;
import net.minecraft.class_1664;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3675;
import net.minecraft.class_4013;
import net.minecraft.class_437;
import net.minecraft.class_8710;

public class BedrockSkinsClient
implements ClientModInitializer {
    private static class_304 toggleCapeKey;
    private static class_304 toggleJacketKey;
    private static class_304 toggleLeftSleeveKey;
    private static class_304 toggleRightSleeveKey;
    private static class_304 toggleLeftPantsKey;
    private static class_304 toggleRightPantsKey;
    private static class_304 toggleHatKey;
    private static class_304 toggleMainHandKey;
    private static class_304.class_11900 keybindCategory;

    public void onInitializeClient() {
        keybindCategory = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"bedrockskins", (String)"controls"));
        this.registerKeyBinding();
        this.registerCustomizationKeybinds();
        this.registerLifecycleEvents();
        this.registerNetworking();
    }

    private void registerKeyBinding() {
        try {
            String keyId = "key.bedrockskins.open";
            class_304 key = new class_304(keyId, class_3675.class_307.field_1668, 75, keybindCategory);
            class_304 openKey = KeyBindingHelper.registerKeyBinding((class_304)key);
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                while (openKey.method_1436()) {
                    client.method_1507((class_437)new SkinSelectionScreen(client.field_1755));
                }
            });
            System.out.println("BedrockSkinsClient: Registered keybinding (K)");
        }
        catch (Exception e) {
            System.out.println("BedrockSkinsClient: Keybinding error: " + String.valueOf(e));
        }
    }

    private void registerCustomizationKeybinds() {
        try {
            toggleCapeKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bedrockskins.toggle_cape", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), keybindCategory));
            toggleJacketKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bedrockskins.toggle_jacket", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), keybindCategory));
            toggleLeftSleeveKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bedrockskins.toggle_left_sleeve", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), keybindCategory));
            toggleRightSleeveKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bedrockskins.toggle_right_sleeve", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), keybindCategory));
            toggleLeftPantsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bedrockskins.toggle_left_pants", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), keybindCategory));
            toggleRightPantsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bedrockskins.toggle_right_pants", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), keybindCategory));
            toggleHatKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bedrockskins.toggle_hat", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), keybindCategory));
            toggleMainHandKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.bedrockskins.swap_main_hand", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), keybindCategory));
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (client.field_1724 == null) {
                    return;
                }
                while (toggleCapeKey.method_1436()) {
                    this.toggleModelPart(client, class_1664.field_7559);
                }
                while (toggleJacketKey.method_1436()) {
                    this.toggleModelPart(client, class_1664.field_7564);
                }
                while (toggleLeftSleeveKey.method_1436()) {
                    this.toggleModelPart(client, class_1664.field_7568);
                }
                while (toggleRightSleeveKey.method_1436()) {
                    this.toggleModelPart(client, class_1664.field_7570);
                }
                while (toggleLeftPantsKey.method_1436()) {
                    this.toggleModelPart(client, class_1664.field_7566);
                }
                while (toggleRightPantsKey.method_1436()) {
                    this.toggleModelPart(client, class_1664.field_7565);
                }
                while (toggleHatKey.method_1436()) {
                    this.toggleModelPart(client, class_1664.field_7563);
                }
                while (toggleMainHandKey.method_1436()) {
                    this.toggleMainHand(client);
                }
            });
            System.out.println("BedrockSkinsClient: Registered customization keybinds");
        }
        catch (Exception e) {
            System.out.println("BedrockSkinsClient: Customization keybinding error: " + String.valueOf(e));
        }
    }

    private void toggleModelPart(class_310 client, class_1664 part) {
        if (client.field_1724 == null) {
            return;
        }
        boolean current = client.field_1690.method_32594(part);
        client.field_1690.method_1635(part, !current);
        client.field_1690.method_1640();
    }

    private void toggleMainHand(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        class_1306 currentHand = (class_1306)client.field_1690.method_42552().method_41753();
        class_1306 newHand = currentHand == class_1306.field_6182 ? class_1306.field_6183 : class_1306.field_6182;
        client.field_1690.method_42552().method_41748((Object)newHand);
        client.field_1690.method_1640();
    }

    private void registerLifecycleEvents() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            this.reloadResources(client);
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new Reloader());
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.applySavedSkinOnJoin(client));
    }

    private void reloadResources(class_310 client) {
        try {
            String localUuid;
            String key;
            SkinPackLoader.loadPacks();
            FavoritesManager.load();
            SkinManager.load();
            BedrockModelManager.clearAllModels();
            if (client.field_1724 != null && (key = SkinManager.getSkin(localUuid = client.field_1724.method_5667().toString())) != null) {
                String[] parts = key.split(":", 2);
                String pack = parts.length == 2 ? parts[0] : "Remote";
                String name = parts.length == 2 ? parts[1] : key;
                SkinManager.setSkin(localUuid, pack, name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void applySavedSkinOnJoin(class_310 client) {
        try {
            byte[] textureData;
            BedrockSkinsState state = StateManager.readState();
            String savedKey = state.getSelected();
            if (savedKey == null) {
                return;
            }
            if (client.field_1724 == null) {
                return;
            }
            String[] parts = savedKey.split(":", 2);
            String pack = parts.length == 2 ? parts[0] : "Remote";
            String name = parts.length == 2 ? parts[1] : savedKey;
            SkinManager.setSkin(client.field_1724.method_5667().toString(), pack, name);
            LoadedSkin loadedSkin = SkinPackLoader.loadedSkins.get(savedKey);
            if (loadedSkin != null && (textureData = this.loadTextureData(client, loadedSkin)).length > 0) {
                ClientPlayNetworking.send((class_8710)new BedrockSkinsNetworking.SetSkinPayload(savedKey, loadedSkin.getGeometryData().toString(), textureData));
                System.out.println("BedrockSkinsClient: Synced skin " + savedKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerNetworking() {
        ClientPlayNetworking.registerGlobalReceiver(BedrockSkinsNetworking.SkinUpdatePayload.ID, (payload, context) -> {
            BedrockSkinsNetworking.SkinUpdatePayload p = payload;
            context.client().execute(() -> {
                String key = p.getSkinKey();
                UUID uuid = p.getUuid();
                String geom = p.getGeometry();
                byte[] tex = p.getTextureData();
                if ("RESET".equals(key)) {
                    SkinManager.resetSkin(uuid.toString());
                } else {
                    SkinPackLoader.registerRemoteSkin(key, geom, tex);
                    String[] parts = key.split(":", 2);
                    String pack = parts.length == 2 ? parts[0] : "Remote";
                    String name = parts.length == 2 ? parts[1] : key;
                    SkinManager.setSkin(uuid.toString(), pack, name);
                }
            });
        });
    }

    private byte[] loadTextureData(class_310 client, LoadedSkin skin) {
        try {
            AssetSource src = skin.getTexture();
            if (src instanceof AssetSource.Resource) {
                Optional resOpt = client.method_1478().method_14486(((AssetSource.Resource)src).getId());
                if (resOpt.isPresent()) {
                    return ((class_3298)resOpt.get()).method_14482().readAllBytes();
                }
                return new byte[0];
            }
            if (src instanceof AssetSource.File) {
                File f = new File(((AssetSource.File)src).getPath());
                return Files.readAllBytes(f.toPath());
            }
            return new byte[0];
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    private final class Reloader
    implements IdentifiableResourceReloadListener,
    class_4013 {
        private Reloader() {
        }

        public class_2960 getFabricId() {
            return class_2960.method_60655((String)"bedrockskins", (String)"reloader");
        }

        public void method_14491(class_3300 manager) {
            BedrockSkinsClient.this.reloadResources(class_310.method_1551());
        }
    }
}

