/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins.client;

import com.brandonitaly.bedrockskins.client.BedrockSkinsState;
import com.brandonitaly.bedrockskins.client.FavoritesManager;
import com.brandonitaly.bedrockskins.client.StateManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_746;

public final class SkinManager {
    private static final Map<String, String> playerSkins = new HashMap<String, String>();

    private SkinManager() {
    }

    public static void load() {
        playerSkins.clear();
        try {
            BedrockSkinsState state = StateManager.readState();
            String selected = state.getSelected();
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            if (selected != null && !selected.isEmpty() && player != null) {
                playerSkins.put(player.method_5667().toString(), selected);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getLocalSelectedKey() {
        String localUuid;
        class_310 client = class_310.method_1551();
        String string = localUuid = client.field_1724 != null ? client.field_1724.method_5667().toString() : null;
        if (localUuid == null) {
            return null;
        }
        return playerSkins.get(localUuid);
    }

    public static void setSkin(String uuid, String packName, String skinName) {
        String localUuid;
        String key = packName + ":" + skinName;
        playerSkins.put(uuid, key);
        class_310 client = class_310.method_1551();
        String string = localUuid = client.field_1724 != null ? client.field_1724.method_5667().toString() : null;
        if (localUuid != null && localUuid.equals(uuid)) {
            try {
                List<String> favorites = FavoritesManager.getFavoriteKeys();
                StateManager.saveState(favorites, key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setPreviewSkin(String uuid, String packName, String skinName) {
        String key = packName + ":" + skinName;
        playerSkins.put(uuid, key);
    }

    public static void resetPreviewSkin(String uuid) {
        playerSkins.remove(uuid);
    }

    public static String getSkin(String uuid) {
        return playerSkins.get(uuid);
    }

    public static void resetSkin(String uuid) {
        if (playerSkins.remove(uuid) != null) {
            String localUuid;
            class_310 client = class_310.method_1551();
            String string = localUuid = client.field_1724 != null ? client.field_1724.method_5667().toString() : null;
            if (localUuid != null && localUuid.equals(uuid)) {
                try {
                    List<String> favorites = FavoritesManager.getFavoriteKeys();
                    StateManager.saveState(favorites, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

