/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins.client.gui;

import com.brandonitaly.bedrockskins.client.gui.PreviewPlayer;
import com.brandonitaly.bedrockskins.pack.LoadedSkin;
import com.brandonitaly.bedrockskins.pack.SkinPackLoader;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_490;
import net.minecraft.class_638;
import net.minecraft.class_6880;

public class SkinGridWidget
extends class_4280<SkinRowEntry> {
    public static final int CELL_WIDTH = 60;
    public static final int CELL_HEIGHT = 85;
    public static final int CELL_PADDING = 5;
    private final Consumer<LoadedSkin> onSelectSkin;
    private final Supplier<LoadedSkin> getSelectedSkin;
    private final class_327 textRenderer;
    private final Consumer<String> registerTextureFor;
    private final PreviewSkinSetter setPreviewSkin;
    private final Consumer<String> resetPreviewSkin;

    public SkinGridWidget(class_310 client, int width, int height, int y, int itemHeight, Consumer<LoadedSkin> onSelectSkin, Supplier<LoadedSkin> getSelectedSkin, class_327 textRenderer, Consumer<String> registerTextureFor, PreviewSkinSetter setPreviewSkin, Consumer<String> resetPreviewSkin) {
        super(client, width, height, y, itemHeight);
        this.onSelectSkin = onSelectSkin;
        this.getSelectedSkin = getSelectedSkin;
        this.textRenderer = textRenderer;
        this.registerTextureFor = registerTextureFor;
        this.setPreviewSkin = setPreviewSkin;
        this.resetPreviewSkin = resetPreviewSkin;
    }

    public int method_25322() {
        return this.field_22758 - 10;
    }

    protected int method_65507() {
        return this.method_46426() + this.field_22758 - 6;
    }

    protected void renderSelection(class_332 context, SkinRowEntry entry, int color) {
    }

    public void addEntryPublic(SkinRowEntry entry) {
        super.method_25321((class_350.class_351)entry);
    }

    public void addSkinsRow(List<LoadedSkin> skins) {
        this.addEntryPublic(new SkinRowEntry(skins));
    }

    public void clear() {
        for (SkinRowEntry row : this.method_25396()) {
            row.cleanup();
        }
        super.method_25339();
    }

    @FunctionalInterface
    public static interface PreviewSkinSetter {
        public void set(String var1, String var2, String var3);
    }

    public class SkinRowEntry
    extends class_4280.class_4281<SkinRowEntry> {
        private final List<SkinCell> cells = new ArrayList<SkinCell>();

        public SkinRowEntry(List<LoadedSkin> skins) {
            for (LoadedSkin skin : skins) {
                this.cells.add(new SkinCell(skin));
            }
        }

        public void cleanup() {
            for (SkinCell cell : this.cells) {
                cell.cleanup();
            }
        }

        private void renderCommon(class_332 context, int x, int y, int mouseX, int mouseY, float tickDelta) {
            for (int i = 0; i < this.cells.size(); ++i) {
                SkinCell cell = this.cells.get(i);
                int cx = x + i * 65;
                boolean isHovered = mouseX >= cx && mouseX < cx + 60 && mouseY >= y && mouseY < y + 85;
                cell.render(context, cx, y, 60, 85, isHovered, tickDelta, mouseX, mouseY);
            }
        }

        private boolean clickCommon(int localX, boolean doubled) {
            int cellStart;
            if (localX < 0) {
                return false;
            }
            int index = localX / 65;
            if (index >= 0 && index < this.cells.size() && localX >= (cellStart = index * 65) && localX <= cellStart + 60) {
                SkinCell cell = this.cells.get(index);
                SkinGridWidget.this.onSelectSkin.accept(cell.skin);
                if (class_310.method_1551().method_1483() != null) {
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                }
                if (doubled) {
                    SkinGridWidget.this.onSelectSkin.accept(cell.skin);
                }
                return true;
            }
            return false;
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.renderCommon(context, this.method_46426(), this.method_46427(), mouseX, mouseY, tickDelta);
        }

        public boolean method_25402(class_11909 click, boolean doubled) {
            return this.clickCommon((int)(click.comp_4798() - (double)this.method_46426()), doubled);
        }

        public class_2561 method_37006() {
            return class_2561.method_43473();
        }

        public class SkinCell {
            private final LoadedSkin skin;
            private PreviewPlayer player;
            private final UUID uuid = UUID.randomUUID();
            private final String name;

            public SkinCell(LoadedSkin skin) {
                String[] parts;
                this.skin = skin;
                String translated = SkinPackLoader.getTranslation(skin.getSafeSkinName());
                this.name = translated != null ? translated : skin.getSkinDisplayName();
                class_638 world = class_310.method_1551().field_1687;
                if (world != null && (parts = skin.getKey().split(":", 2)).length == 2) {
                    try {
                        SkinGridWidget.this.registerTextureFor.accept(skin.getKey());
                        SkinGridWidget.this.setPreviewSkin.set(this.uuid.toString(), parts[0], parts[1]);
                        this.player = PreviewPlayer.PreviewPlayerPool.get(world, new GameProfile(this.uuid, ""));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void cleanup() {
                try {
                    SkinGridWidget.this.resetPreviewSkin.accept(this.uuid.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PreviewPlayer.PreviewPlayerPool.remove(this.uuid);
            }

            public void render(class_332 context, int x, int y, int w, int h, boolean hovered, float delta, int mouseX, int mouseY) {
                boolean isSelected;
                LoadedSkin selected = SkinGridWidget.this.getSelectedSkin.get();
                boolean bl = isSelected = selected != null && selected.equals(this.skin);
                int borderColor = isSelected ? -256 : (hovered ? -1 : -16777216);
                int bgColor = isSelected ? -2141891243 : 0x40000000;
                context.method_25294(x, y, x + w, y + h, bgColor);
                this.drawBorder(context, x, y, w, h, borderColor);
                if (this.player != null) {
                    float pX = (float)x + (float)w / 2.0f;
                    float pY = (float)y + (float)h / 2.0f;
                    class_490.method_2486((class_332)context, (int)(x + 2), (int)(y + 2), (int)(x + w - 2), (int)(y + h - 4), (int)30, (float)0.0625f, (float)pX, (float)pY, (class_1309)this.player);
                }
                if (hovered) {
                    context.method_51438(SkinGridWidget.this.textRenderer, (class_2561)class_2561.method_43470((String)this.name), mouseX, mouseY);
                }
            }

            private void drawBorder(class_332 context, int x, int y, int width, int height, int color) {
                context.method_25294(x, y, x + width, y + 1, color);
                context.method_25294(x, y + height - 1, x + width, y + height, color);
                context.method_25294(x, y + 1, x + 1, y + height - 1, color);
                context.method_25294(x + width - 1, y + 1, x + width, y + height - 1, color);
            }
        }
    }
}

