/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins.client.gui;

import com.brandonitaly.bedrockskins.BedrockSkinsNetworking;
import com.brandonitaly.bedrockskins.client.FavoritesManager;
import com.brandonitaly.bedrockskins.client.SkinManager;
import com.brandonitaly.bedrockskins.client.StateManager;
import com.brandonitaly.bedrockskins.client.gui.PreviewPlayer;
import com.brandonitaly.bedrockskins.pack.AssetSource;
import com.brandonitaly.bedrockskins.pack.LoadedSkin;
import com.brandonitaly.bedrockskins.pack.SkinPackLoader;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.nio.file.Files;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10017;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SkinPreviewPanel {
    private final class_310 minecraft;
    private final class_327 font;
    private final Runnable onFavoritesChanged;
    private static final class_2960 ROTATE_SPRITE = class_2960.method_60655((String)"bedrockskins", (String)"container/rotate");
    private int x;
    private int y;
    private int width;
    private int height;
    private FavoriteHeartButton favoriteButton;
    private class_4185 selectButton;
    private LoadedSkin selectedSkin;
    private String currentSkinKey;
    private PreviewPlayer dummyPlayer;
    private UUID dummyUuid = UUID.randomUUID();
    private float rotationX = 0.0f;
    private int lastMouseX = 0;
    private boolean isDraggingPreview = false;
    private int previewLeft;
    private int previewRight;
    private int previewTop;
    private int previewBottom;

    public SkinPreviewPanel(class_310 minecraft, class_327 font, Runnable onFavoritesChanged) {
        this.minecraft = minecraft;
        this.font = font;
        this.onFavoritesChanged = onFavoritesChanged;
    }

    public LoadedSkin getSelectedSkin() {
        return this.selectedSkin;
    }

    public void init(int x, int y, int w, int h, Consumer<class_339> widgetAdder) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        int PANEL_HEADER_HEIGHT = 24;
        int buttonsHeight = 90;
        int entityY = y + PANEL_HEADER_HEIGHT;
        int entityH = h - PANEL_HEADER_HEIGHT - buttonsHeight;
        int availableHeight = Math.max(entityH, 50);
        this.previewLeft = x;
        this.previewRight = x + w;
        this.previewTop = entityY;
        this.previewBottom = entityY + availableHeight;
        int PANEL_PADDING = 4;
        int btnW = Math.min(this.width - 16, 140);
        int btnH = 20;
        int btnX = x + this.width / 2 - btnW / 2;
        int startY = y + h - PANEL_PADDING - btnH - 4;
        widgetAdder.accept((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"bedrockskins.button.reset"), b -> this.resetSkin()).method_46434(btnX, startY, btnW, btnH).method_46431());
        int selectBtnW = btnW - 20 - 2;
        int selectBtnX = btnX + 20 + 2;
        this.selectButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"bedrockskins.button.select"), b -> this.applySkin()).method_46434(selectBtnX, startY -= btnH + 4, selectBtnW, btnH).method_46431();
        widgetAdder.accept((class_339)this.selectButton);
        class_2960 heartEmpty = class_2960.method_60655((String)"minecraft", (String)"hud/heart/container");
        class_2960 heartFull = class_2960.method_60655((String)"minecraft", (String)"hud/heart/full");
        this.favoriteButton = new FavoriteHeartButton(btnX, startY, 20, heartEmpty, heartFull, b -> this.toggleFavorite());
        widgetAdder.accept(this.favoriteButton.getButton());
        this.initPreviewState();
    }

    public void initPreviewState() {
        if (this.selectedSkin != null) {
            this.updatePreviewModel(this.dummyUuid, this.selectedSkin.getKey());
            return;
        }
        String currentKey = SkinManager.getLocalSelectedKey();
        if (currentKey != null && !currentKey.isEmpty()) {
            this.dummyUuid = UUID.randomUUID();
            this.currentSkinKey = currentKey;
            LoadedSkin currentSkin = SkinPackLoader.loadedSkins.get(currentKey);
            if (currentSkin != null) {
                this.selectedSkin = currentSkin;
            }
            this.updatePreviewModel(this.dummyUuid, currentKey);
            this.updateFavoriteButton();
        } else {
            this.dummyUuid = this.minecraft.field_1724 != null ? this.minecraft.field_1724.method_5667() : UUID.randomUUID();
            this.currentSkinKey = null;
            this.updatePreviewModel(this.dummyUuid, null);
            this.updateFavoriteButton();
        }
    }

    public void setSelectedSkin(LoadedSkin skin) {
        this.selectedSkin = skin;
        this.currentSkinKey = skin != null ? skin.getKey() : null;
        this.updateFavoriteButton();
        if (skin != null) {
            if (this.minecraft.field_1724 != null && this.dummyUuid.equals(this.minecraft.field_1724.method_5667())) {
                this.safeResetPreview(this.dummyUuid.toString());
                this.dummyUuid = UUID.randomUUID();
            }
            this.updatePreviewModel(this.dummyUuid, skin.getKey());
        }
    }

    private void updatePreviewModel(UUID uuid, String skinKey) {
        String[] parts;
        if (this.minecraft.field_1687 == null) {
            return;
        }
        if (!this.dummyUuid.equals(uuid)) {
            this.safeResetPreview(this.dummyUuid.toString());
        }
        this.dummyUuid = uuid;
        if (skinKey != null && (parts = skinKey.split(":", 2)).length == 2) {
            SkinManager.setPreviewSkin(uuid.toString(), parts[0], parts[1]);
            this.safeRegisterTexture(skinKey);
        }
        String name = this.minecraft.field_1724 != null ? this.minecraft.field_1724.method_5477().getString() : "Preview";
        GameProfile profile = new GameProfile(uuid, name);
        this.dummyPlayer = PreviewPlayer.PreviewPlayerPool.get(this.minecraft.field_1687, profile);
        class_2960 capeToUse = this.selectedSkin != null ? this.selectedSkin.capeIdentifier : null;
        this.dummyPlayer.setForcedCape(capeToUse);
    }

    private void applySkin() {
        if (this.selectedSkin == null) {
            return;
        }
        try {
            byte[] data = this.loadTextureData(this.selectedSkin);
            String key = this.selectedSkin.getKey();
            String[] parts = key.split(":", 2);
            String pack = parts.length == 2 ? parts[0] : "Remote";
            String name = parts.length == 2 ? parts[1] : key;
            this.safeRegisterTexture(key);
            if (this.minecraft.field_1724 != null) {
                String dispName;
                SkinManager.setSkin(this.minecraft.field_1724.method_5667().toString(), pack, name);
                if (data.length > 0) {
                    ClientPlayNetworking.send((class_8710)new BedrockSkinsNetworking.SetSkinPayload(key, this.selectedSkin.getGeometryData().toString(), data));
                }
                if ((dispName = SkinPackLoader.getTranslation(this.selectedSkin.getSafeSkinName())) == null) {
                    dispName = this.selectedSkin.getSkinDisplayName();
                }
                this.minecraft.field_1724.method_7353((class_2561)class_2561.method_43469((String)"bedrockskins.message.set_skin", (Object[])new Object[]{dispName}).method_27692(class_124.field_1060), true);
            } else {
                StateManager.saveState(FavoritesManager.getFavoriteKeys(), key);
                this.updatePreviewModel(this.dummyUuid, key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resetSkin() {
        this.selectedSkin = null;
        this.currentSkinKey = null;
        if (this.minecraft.field_1724 != null) {
            SkinManager.resetSkin(this.minecraft.field_1724.method_5667().toString());
            ClientPlayNetworking.send((class_8710)new BedrockSkinsNetworking.SetSkinPayload("RESET", "", new byte[0]));
            this.minecraft.field_1724.method_7353((class_2561)class_2561.method_43471((String)"bedrockskins.message.reset_default").method_27692(class_124.field_1054), true);
            this.safeResetPreview(this.dummyUuid.toString());
            this.dummyUuid = this.minecraft.field_1724.method_5667();
            this.updatePreviewModel(this.dummyUuid, null);
        } else {
            StateManager.saveState(FavoritesManager.getFavoriteKeys(), null);
            this.safeResetPreview(this.dummyUuid.toString());
        }
        this.updateFavoriteButton();
    }

    private void toggleFavorite() {
        if (this.selectedSkin == null) {
            return;
        }
        if (FavoritesManager.isFavorite(this.selectedSkin)) {
            FavoritesManager.removeFavorite(this.selectedSkin);
        } else {
            FavoritesManager.addFavorite(this.selectedSkin);
        }
        this.updateFavoriteButton();
        if (this.onFavoritesChanged != null) {
            this.onFavoritesChanged.run();
        }
    }

    private void updateFavoriteButton() {
        if (this.favoriteButton == null) {
            return;
        }
        boolean hasSkin = this.currentSkinKey != null;
        boolean isFav = this.selectedSkin != null && FavoritesManager.isFavorite(this.selectedSkin);
        this.favoriteButton.setSelected(isFav);
        this.favoriteButton.setActive(hasSkin);
        this.favoriteButton.setTooltip((class_2561)class_2561.method_43471((String)(isFav ? "bedrockskins.button.unfavorite" : "bedrockskins.button.favorite")));
        if (this.selectButton != null) {
            this.selectButton.field_22763 = this.selectedSkin != null;
        }
    }

    public void render(class_332 gui, int mouseX, int mouseY) {
        this.drawPanel(gui, this.x, this.y, this.width, this.height, (class_2561)class_2561.method_43471((String)"bedrockskins.gui.preview"));
        int PANEL_HEADER_HEIGHT = 24;
        int entityY = this.y + PANEL_HEADER_HEIGHT;
        int buttonsHeight = 90;
        int entityH = this.height - PANEL_HEADER_HEIGHT - buttonsHeight;
        int rotateW = 45;
        int rotateH = 7;
        int rotateGap = 6;
        int reservedForRotate = rotateH + rotateGap;
        int availableHeight = Math.max(entityH - reservedForRotate, 0);
        this.previewLeft = this.x;
        this.previewRight = this.x + this.width;
        this.previewTop = entityY;
        this.previewBottom = entityY + availableHeight;
        int centerX = this.x + this.width / 2;
        int centerY = entityY + availableHeight / 2 + 15;
        if (this.dummyPlayer != null) {
            this.dummyPlayer.field_6012 = (int)(class_156.method_658() / 50L);
            if (this.isDraggingPreview) {
                float sensitivity = 0.5f;
                float deltaX = (float)(mouseX - this.lastMouseX) * sensitivity;
                this.rotationX -= deltaX;
            }
            this.lastMouseX = mouseX;
            this.renderRotatableEntity(gui, centerX, centerY, this.width, availableHeight, (class_1309)this.dummyPlayer);
            int rotateX = centerX - rotateW / 2;
            int rotateY = this.previewBottom + rotateGap;
            gui.method_52706(class_10799.field_56883, ROTATE_SPRITE, rotateX, rotateY, rotateW, rotateH);
        } else {
            int n = entityY + availableHeight / 2;
            Objects.requireNonNull(this.font);
            int textY = n - 9 / 2;
            gui.method_27534(this.font, (class_2561)class_2561.method_43471((String)"bedrockskins.preview.unavailable"), centerX, textY, -5592406);
        }
        if (this.selectedSkin != null) {
            String name = SkinPackLoader.getTranslation(this.selectedSkin.getSafeSkinName());
            if (name == null) {
                name = this.selectedSkin.getSkinDisplayName();
            }
            int PANEL_PADDING = 4;
            int btnH = 20;
            Objects.requireNonNull(this.font);
            int textY = this.y + this.height - PANEL_PADDING - btnH * 2 - 8 - 9 - 4;
            gui.method_25300(this.font, name, centerX, textY, -5592406);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)this.previewLeft && mouseX <= (double)this.previewRight && mouseY >= (double)this.previewTop && mouseY <= (double)this.previewBottom) {
            this.isDraggingPreview = true;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDraggingPreview) {
            this.isDraggingPreview = false;
            return true;
        }
        return false;
    }

    private void renderRotatableEntity(class_332 gui, int x, int y, int width, int height, class_1309 entity) {
        int size = Math.min((int)((double)height / 2.5), 80);
        float rotationModifier = 3.0f;
        float yBodyRot = entity.field_6283;
        float yRot = entity.method_36454();
        float yRotO = entity.field_5982;
        float yBodyRotO = entity.field_6220;
        float xRot = entity.method_36455();
        float xRotO = entity.field_6004;
        float yHeadRotO = entity.field_6259;
        float yHeadRot = entity.field_6241;
        class_243 vel = entity.method_18798();
        entity.field_6283 = 180.0f + this.rotationX * rotationModifier;
        entity.method_36456(180.0f + this.rotationX * rotationModifier);
        entity.field_6220 = entity.field_6283;
        entity.field_5982 = entity.method_36454();
        entity.method_18799(class_243.field_1353);
        entity.method_36457(0.0f);
        entity.field_6004 = entity.method_36455();
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        Quaternionf quaternion = new Quaternionf().rotationZ((float)Math.toRadians(180.0));
        Quaternionf quaternion2 = new Quaternionf().rotationX(0.0f);
        quaternion.mul((Quaternionfc)quaternion2);
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        class_897 entityRenderer = entityRenderDispatcher.method_3953((class_1297)entity);
        class_10017 entityRenderState = entityRenderer.method_62425((class_1297)entity, 1.0f);
        entityRenderState.field_61820 = 0xF000F0;
        entityRenderState.field_53330 = 0.0f;
        entityRenderState.field_53329 = 0.0f;
        float scale = entity.method_55693();
        Vector3f vector3f = new Vector3f(0.0f, entity.method_17682() / 2.0f, 0.0f);
        float renderScale = (float)size / scale;
        quaternion2.conjugate();
        gui.method_70856(entityRenderState, renderScale, vector3f, quaternion, quaternion2, x - width, y - height, x + width, y + height);
        entity.field_6283 = yBodyRot;
        entity.field_6220 = yBodyRotO;
        entity.method_36456(yRot);
        entity.field_5982 = yRotO;
        entity.method_36457(xRot);
        entity.field_6004 = xRotO;
        entity.field_6259 = yHeadRotO;
        entity.field_6241 = yHeadRot;
        entity.method_18799(vel);
    }

    public void renderSprites(class_332 gui) {
        if (this.favoriteButton != null) {
            this.favoriteButton.renderSprites(gui);
        }
    }

    private void drawPanel(class_332 gui, int x, int y, int w, int h, class_2561 title) {
        int PANEL_HEADER_HEIGHT = 24;
        int right = x + w;
        int bottom = y + h;
        int COL_PANEL_BG = -434628584;
        int COL_PANEL_HEADER = -14342875;
        int COL_BORDER_OUTER = -16777216;
        int COL_BORDER_INNER = -13092808;
        int COL_TEXT_TITLE = -1;
        gui.method_25294(x - 1, y - 1, right + 1, bottom + 1, COL_BORDER_OUTER);
        gui.method_25294(x, y, right, bottom, COL_PANEL_BG);
        gui.method_25294(x, y, right, y + PANEL_HEADER_HEIGHT, COL_PANEL_HEADER);
        gui.method_25294(x, y + PANEL_HEADER_HEIGHT, right, y + PANEL_HEADER_HEIGHT + 1, COL_BORDER_INNER);
        gui.method_27534(this.font, title, x + w / 2, y + 8, COL_TEXT_TITLE);
        gui.method_25294(x, y, right, y + 1, COL_BORDER_INNER);
        gui.method_25294(x, bottom - 1, right, bottom, COL_BORDER_INNER);
        gui.method_25294(x, y, x + 1, bottom, COL_BORDER_INNER);
        gui.method_25294(right - 1, y, right, bottom, COL_BORDER_INNER);
    }

    private void safeResetPreview(String uuid) {
        try {
            SkinManager.resetPreviewSkin(uuid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeRegisterTexture(String key) {
        try {
            SkinPackLoader.registerTextureFor(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] loadTextureData(LoadedSkin skin) {
        try {
            AssetSource src = skin.getTexture();
            if (src instanceof AssetSource.Resource) {
                AssetSource.Resource res = (AssetSource.Resource)src;
                Optional resOpt = this.minecraft.method_1478().method_14486(res.getId());
                if (resOpt.isPresent()) {
                    return ((class_3298)resOpt.get()).method_14482().readAllBytes();
                }
            } else if (src instanceof AssetSource.File) {
                AssetSource.File f = (AssetSource.File)src;
                return Files.readAllBytes(new File(f.getPath()).toPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new byte[0];
    }

    private static class FavoriteHeartButton {
        private final class_4185 button;
        private final class_2960 containerSprite;
        private final class_2960 fullSprite;
        private boolean isFavorited = false;

        public FavoriteHeartButton(int x, int y, int size, class_2960 containerSprite, class_2960 fullSprite, class_4185.class_4241 onPress) {
            this.containerSprite = containerSprite;
            this.fullSprite = fullSprite;
            this.button = class_4185.method_46430((class_2561)class_2561.method_43473(), (class_4185.class_4241)onPress).method_46437(size, size).method_46431();
            this.button.method_48229(x, y);
        }

        public class_339 getButton() {
            return this.button;
        }

        public void setSelected(boolean selected) {
            this.isFavorited = selected;
        }

        public void setActive(boolean active) {
            this.button.field_22763 = active;
        }

        public void setTooltip(class_2561 tooltip) {
            this.button.method_47400(class_7919.method_47407((class_2561)tooltip));
        }

        public void renderSprites(class_332 graphics) {
            if (this.button.field_22764) {
                graphics.method_52706(class_10799.field_56883, this.containerSprite, this.button.method_46426() + 4, this.button.method_46427() + 4, 12, 12);
                if (this.isFavorited) {
                    graphics.method_52706(class_10799.field_56883, this.fullSprite, this.button.method_46426() + 4, this.button.method_46427() + 4, 12, 12);
                }
            }
        }
    }
}

