/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins.client.gui;

import com.brandonitaly.bedrockskins.client.FavoritesManager;
import com.brandonitaly.bedrockskins.client.SkinManager;
import com.brandonitaly.bedrockskins.client.gui.SkinGridWidget;
import com.brandonitaly.bedrockskins.client.gui.SkinPackListWidget;
import com.brandonitaly.bedrockskins.client.gui.SkinPreviewPanel;
import com.brandonitaly.bedrockskins.pack.LoadedSkin;
import com.brandonitaly.bedrockskins.pack.SkinPackLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

public class SkinSelectionScreen
extends class_437 {
    private SkinPackListWidget packList;
    private SkinGridWidget skinGrid;
    private SkinPreviewPanel previewPanel;
    private final class_437 parent;
    private String selectedPackId;
    private boolean wasMousePressed = false;
    private final Map<String, List<LoadedSkin>> skinCache = new HashMap<String, List<LoadedSkin>>();
    private final Rect rPacks = new Rect();
    private final Rect rSkins = new Rect();
    private final Rect rPreview = new Rect();

    public SkinSelectionScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"bedrockskins.gui.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        FavoritesManager.load();
        this.buildSkinCache();
        this.calculateLayout();
        this.initWidgets();
    }

    private void buildSkinCache() {
        this.skinCache.clear();
        for (LoadedSkin skin : SkinPackLoader.loadedSkins.values()) {
            this.skinCache.computeIfAbsent(skin.getId(), k -> new ArrayList()).add(skin);
        }
        ArrayList<LoadedSkin> favs = new ArrayList<LoadedSkin>();
        for (String key : FavoritesManager.getFavoriteKeys()) {
            LoadedSkin s = SkinPackLoader.loadedSkins.get(key);
            if (s == null) continue;
            favs.add(s);
        }
        this.skinCache.put("skinpack.Favorites", favs);
    }

    private void calculateLayout() {
        int topNav = 32;
        int botNav = 32;
        int hMargin = 10;
        int gap = 6;
        int fullW = this.field_22789 - hMargin * 2;
        int fullH = this.field_22790 - topNav - botNav;
        int sideW = Math.max(130, Math.min(200, (int)((double)fullW * 0.22)));
        int centerW = fullW - sideW * 2 - gap * 2;
        if (centerW < 100) {
            sideW = (fullW - 100 - gap * 2) / 2;
            centerW = 100;
        }
        this.rPacks.set(hMargin, topNav, sideW, fullH);
        this.rSkins.set(this.rPacks.right() + gap, topNav, centerW, fullH);
        this.rPreview.set(this.rSkins.right() + gap, topNav, sideW, fullH);
    }

    private void initWidgets() {
        if (this.field_22787 == null) {
            return;
        }
        int PANEL_HEADER_HEIGHT = 24;
        int PANEL_PADDING = 4;
        int plY = this.rPacks.y + PANEL_HEADER_HEIGHT + PANEL_PADDING;
        int plH = this.rPacks.h - PANEL_HEADER_HEIGHT - PANEL_PADDING * 2;
        this.packList = new SkinPackListWidget(this.field_22787, this.rPacks.w - PANEL_PADDING * 2, plH, plY, 24, this::selectPack, id -> Objects.equals(this.selectedPackId, id), this.field_22793);
        ReflectionHelper.setPos((Object)this.packList, this.rPacks.x + PANEL_PADDING, plY);
        this.method_37063((class_364)this.packList);
        this.previewPanel = new SkinPreviewPanel(this.field_22787, this.field_22793, this::onFavoritesChanged);
        this.previewPanel.init(this.rPreview.x, this.rPreview.y, this.rPreview.w, this.rPreview.h, x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        int sgY = this.rSkins.y + PANEL_HEADER_HEIGHT + PANEL_PADDING;
        int sgH = this.rSkins.h - PANEL_HEADER_HEIGHT - PANEL_PADDING * 2;
        this.skinGrid = new SkinGridWidget(this.field_22787, this.rSkins.w - PANEL_PADDING * 2, sgH, sgY, 90, skin -> this.previewPanel.setSelectedSkin((LoadedSkin)skin), () -> this.previewPanel != null ? this.previewPanel.getSelectedSkin() : null, this.field_22793, this::safeRegisterTexture, SkinManager::setPreviewSkin, this::safeResetPreview);
        ReflectionHelper.setPos((Object)this.skinGrid, this.rSkins.x + PANEL_PADDING, sgY);
        this.method_37063((class_364)this.skinGrid);
        this.initFooterButtons();
        this.refreshPackList();
        if (this.selectedPackId != null) {
            this.selectPack(this.selectedPackId);
        }
    }

    private void onFavoritesChanged() {
        this.buildSkinCache();
        this.refreshPackList();
        if ("skinpack.Favorites".equals(this.selectedPackId)) {
            this.selectPack("skinpack.Favorites");
        }
    }

    private void initFooterButtons() {
        int btnW = 150;
        int gap = 10;
        int y = this.field_22790 - 24;
        int centerX = this.field_22789 / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"bedrockskins.button.open_packs"), b -> this.openSkinPacksFolder()).method_46434(centerX - btnW - gap / 2, y, btnW, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.method_25419()).method_46434(centerX + gap / 2, y, btnW, 20).method_46431());
    }

    private void refreshPackList() {
        if (this.packList == null) {
            return;
        }
        this.packList.clear();
        ArrayList<String> sortedPacks = new ArrayList<String>(this.skinCache.keySet());
        sortedPacks.remove("skinpack.Favorites");
        sortedPacks.sort((k1, k2) -> {
            int i1 = SkinPackLoader.packOrder.indexOf(k1);
            int i2 = SkinPackLoader.packOrder.indexOf(k2);
            if (i1 != -1 && i2 != -1) {
                return Integer.compare(i1, i2);
            }
            if (i1 != -1) {
                return -1;
            }
            if (i2 != -1) {
                return 1;
            }
            return k1.compareToIgnoreCase((String)k2);
        });
        if (!FavoritesManager.getFavoriteKeys().isEmpty()) {
            sortedPacks.add(0, "skinpack.Favorites");
        }
        Iterator iterator = sortedPacks.iterator();
        while (iterator.hasNext()) {
            String pid;
            String display = pid = (String)iterator.next();
            String internal = pid;
            List<LoadedSkin> skins = this.skinCache.get(pid);
            if (skins != null && !skins.isEmpty()) {
                LoadedSkin first = skins.get(0);
                display = first.getSafePackName();
                internal = first.getPackDisplayName();
            }
            if ("skinpack.Favorites".equals(pid)) {
                display = "Favorites";
                internal = "Favorites";
            }
            this.packList.addEntryPublic(new SkinPackListWidget.SkinPackEntry(pid, display, internal, this::selectPack, () -> Objects.equals(this.selectedPackId, pid), this.field_22793));
        }
    }

    private void selectPack(String packId) {
        this.selectedPackId = packId;
        if (this.skinGrid != null) {
            this.skinGrid.clear();
            this.skinGrid.method_44382(0.0);
        }
        List skins = this.skinCache.getOrDefault(packId, Collections.emptyList());
        int itemWidth = 65;
        int totalWidth = this.rSkins.w - 8 - 10;
        int cols = Math.max(1, totalWidth / itemWidth);
        for (int i = 0; i < skins.size(); i += cols) {
            List<LoadedSkin> row = skins.subList(i, Math.min(i + cols, skins.size()));
            this.skinGrid.addSkinsRow(row);
        }
    }

    private void openSkinPacksFolder() {
        File dir = new File(this.field_22787.field_1697, "skin_packs");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        class_156.method_668().method_672(dir);
    }

    private void safeRegisterTexture(String key) {
        try {
            SkinPackLoader.registerTextureFor(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeResetPreview(String uuid) {
        try {
            SkinManager.resetPreviewSkin(uuid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        boolean mousePressed;
        gui.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, -1);
        this.drawPanel(gui, this.rPacks, (class_2561)class_2561.method_43471((String)"bedrockskins.gui.packs"));
        this.drawPanel(gui, this.rSkins, (class_2561)class_2561.method_43471((String)"bedrockskins.gui.skins"));
        boolean bl = mousePressed = GLFW.glfwGetMouseButton((long)GLFW.glfwGetCurrentContext(), (int)0) == 1;
        if (this.previewPanel != null) {
            if (mousePressed && !this.wasMousePressed) {
                this.previewPanel.mouseClicked(mouseX, mouseY, 0);
            }
            if (!mousePressed && this.wasMousePressed) {
                this.previewPanel.mouseReleased(mouseX, mouseY, 0);
            }
            this.wasMousePressed = mousePressed;
            this.previewPanel.render(gui, mouseX, mouseY);
        }
        super.method_25394(gui, mouseX, mouseY, delta);
        if (this.previewPanel != null) {
            this.previewPanel.renderSprites(gui);
        }
    }

    private void drawPanel(class_332 gui, Rect r, class_2561 title) {
        int PANEL_HEADER_HEIGHT = 24;
        int COL_PANEL_BG = -434628584;
        int COL_PANEL_HEADER = -14342875;
        int COL_BORDER_OUTER = -16777216;
        int COL_BORDER_INNER = -13092808;
        int COL_TEXT_TITLE = -1;
        gui.method_25294(r.x - 1, r.y - 1, r.right() + 1, r.bottom() + 1, COL_BORDER_OUTER);
        gui.method_25294(r.x, r.y, r.right(), r.bottom(), COL_PANEL_BG);
        gui.method_25294(r.x, r.y, r.right(), r.y + PANEL_HEADER_HEIGHT, COL_PANEL_HEADER);
        gui.method_25294(r.x, r.y + PANEL_HEADER_HEIGHT, r.right(), r.y + PANEL_HEADER_HEIGHT + 1, COL_BORDER_INNER);
        gui.method_27534(this.field_22793, title, r.centerX(), r.y + 8, COL_TEXT_TITLE);
        gui.method_25294(r.x, r.y, r.right(), r.y + 1, COL_BORDER_INNER);
        gui.method_25294(r.x, r.bottom() - 1, r.right(), r.bottom(), COL_BORDER_INNER);
        gui.method_25294(r.x, r.y, r.x + 1, r.bottom(), COL_BORDER_INNER);
        gui.method_25294(r.right() - 1, r.y, r.right(), r.bottom(), COL_BORDER_INNER);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private static class Rect {
        int x;
        int y;
        int w;
        int h;

        private Rect() {
        }

        void set(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        int right() {
            return this.x + this.w;
        }

        int bottom() {
            return this.y + this.h;
        }

        int centerX() {
            return this.x + this.w / 2;
        }
    }

    private static class ReflectionHelper {
        private static Method setPosition;

        private ReflectionHelper() {
        }

        static void setPos(Object widget, int x, int y) {
            Class<?> clz;
            block16: {
                if (widget instanceof class_339) {
                    class_339 aw = (class_339)widget;
                    aw.method_46421(x);
                    aw.method_46419(y);
                    return;
                }
                clz = widget.getClass();
                if (setPosition == null) break block16;
                setPosition.invoke(widget, x, y);
                return;
            }
            try {
                Method mx = clz.getMethod("setX", Integer.TYPE);
                mx.invoke(widget, x);
                try {
                    clz.getMethod("setY", Integer.TYPE).invoke(widget, y);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            catch (Exception mx) {
                try {
                    try {
                        Method m = clz.getMethod("setLeftPos", Integer.TYPE);
                        m.invoke(widget, x);
                        try {
                            clz.getMethod("setTopPos", Integer.TYPE).invoke(widget, y);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (Exception m) {
                        try {
                            setPosition = m2 = clz.getMethod("setPosition", Integer.TYPE, Integer.TYPE);
                            m2.invoke(widget, x, y);
                        }
                        catch (Exception m2) {}
                    }
                }
                catch (Exception ignored) {
                    try {
                        Field fx = widget.getClass().getField("x");
                        fx.setAccessible(true);
                        fx.setInt(widget, x);
                        Field fy = widget.getClass().getField("y");
                        fy.setAccessible(true);
                        fy.setInt(widget, y);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

