/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins.mixins;

import com.brandonitaly.bedrockskins.client.BedrockModelManager;
import com.brandonitaly.bedrockskins.client.BedrockPlayerModel;
import com.brandonitaly.bedrockskins.client.BedrockSkinState;
import java.util.UUID;
import net.minecraft.class_10034;
import net.minecraft.class_10055;
import net.minecraft.class_11659;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_640;
import net.minecraft.class_8685;
import net.minecraft.class_970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_970.class})
public abstract class MixinArmorFeatureRenderer {
    @Unique
    private final ThreadLocal<Boolean> pushed = new ThreadLocal();

    @Unique
    private void bedrockSkins$configureVisibility(UUID uuid, boolean isPlayerRenderState, boolean stateCapeVisible) {
        if (uuid == null) {
            return;
        }
        BedrockPlayerModel model = BedrockModelManager.getModel(uuid);
        if (!(model instanceof BedrockPlayerModel)) {
            return;
        }
        BedrockPlayerModel bedrockModel = model;
        bedrockModel.setBedrockPartVisible("bodyArmor", true);
        bedrockModel.setBedrockPartVisible("helmet", true);
        boolean hasCape = false;
        if (isPlayerRenderState && stateCapeVisible) {
            hasCape = this.bedrockSkins$hasCapeTexture(uuid);
        }
        if (!hasCape) {
            boolean bl = hasCape = bedrockModel.partsMap.containsKey("cape") || bedrockModel.partsMap.containsKey("elytra");
        }
        if (hasCape) {
            bedrockModel.setBedrockPartVisible("bodyArmor", false);
        }
    }

    @Unique
    private boolean bedrockSkins$hasCapeTexture(UUID uuid) {
        try {
            class_310 client = class_310.method_1551();
            if (client == null || client.method_1562() == null) {
                return false;
            }
            class_640 entry = client.method_1562().method_2871(uuid);
            if (entry == null) {
                return false;
            }
            class_8685 textures = entry.method_52810();
            if (textures == null) {
                return false;
            }
            return textures.comp_1627() != null;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Unique
    private void bedrockSkins$applyArmorOffset(class_4587 matrices, Object modelObj, class_1799 stack, class_1304 slot) {
        if (!(modelObj instanceof BedrockPlayerModel)) {
            return;
        }
        BedrockPlayerModel bedrockModel = (BedrockPlayerModel)((Object)modelObj);
        if (!stack.method_7960()) {
            if (slot == class_1304.field_6174) {
                bedrockModel.setBedrockPartVisible("bodyArmor", false);
            } else if (slot == class_1304.field_6169) {
                bedrockModel.setBedrockPartVisible("helmet", false);
            }
        }
        float pixels = 0.0f;
        if (slot == class_1304.field_6169 || slot == class_1304.field_6174) {
            pixels = bedrockModel.upperArmorYOffset;
        }
        if (pixels != 0.0f) {
            matrices.method_22903();
            matrices.method_22904(0.0, (double)(pixels * 0.0625f), 0.0);
            this.pushed.set(true);
        }
    }

    @Unique
    private void bedrockSkins$resetMatrix(class_4587 matrices) {
        if (Boolean.TRUE.equals(this.pushed.get())) {
            try {
                matrices.method_22909();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pushed.remove();
        }
    }

    @Inject(method={"method_17157"}, at={@At(value="HEAD")})
    private void onRenderHead(class_4587 matrices, class_11659 queue, int light, class_10034 state, float limbAngle, float limbDistance, CallbackInfo ci) {
        UUID uUID;
        if (state instanceof BedrockSkinState) {
            BedrockSkinState skinState = (BedrockSkinState)state;
            uUID = skinState.getUniqueId();
        } else {
            uUID = null;
        }
        UUID uuid = uUID;
        boolean isPlayerState = state instanceof class_10055;
        boolean capeVisible = isPlayerState && ((class_10055)state).field_53532;
        this.bedrockSkins$configureVisibility(uuid, isPlayerState, capeVisible);
    }

    @Inject(method={"method_4169"}, at={@At(value="HEAD")})
    private void beforeRenderArmor(class_4587 matrices, class_11659 queue, class_1799 stack, class_1304 slot, int light, class_10034 state, CallbackInfo ci) {
        UUID uUID;
        if (state instanceof BedrockSkinState) {
            BedrockSkinState skinState = (BedrockSkinState)state;
            uUID = skinState.getUniqueId();
        } else {
            uUID = null;
        }
        UUID uuid = uUID;
        BedrockPlayerModel model = uuid != null ? BedrockModelManager.getModel(uuid) : null;
        this.bedrockSkins$applyArmorOffset(matrices, (Object)model, stack, slot);
    }

    @Inject(method={"method_4169"}, at={@At(value="RETURN")})
    private void afterRenderArmor(class_4587 matrices, class_11659 queue, class_1799 stack, class_1304 slot, int light, class_10034 state, CallbackInfo ci) {
        this.bedrockSkins$resetMatrix(matrices);
    }
}

