/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins.pack;

import com.brandonitaly.bedrockskins.pack.AssetSource;
import com.brandonitaly.bedrockskins.pack.StringUtils;
import com.google.gson.JsonObject;
import net.minecraft.class_2960;

public class LoadedSkin {
    public final String serializeName;
    public final String packDisplayName;
    public final String skinDisplayName;
    public final JsonObject geometryData;
    public final AssetSource texture;
    public final AssetSource cape;
    public class_2960 identifier;
    public class_2960 capeIdentifier;

    public LoadedSkin(String serializeName, String packDisplayName, String skinDisplayName, JsonObject geometryData, AssetSource texture) {
        this(serializeName, packDisplayName, skinDisplayName, geometryData, texture, null);
    }

    public LoadedSkin(String serializeName, String packDisplayName, String skinDisplayName, JsonObject geometryData, AssetSource texture, AssetSource cape) {
        this.serializeName = serializeName;
        this.packDisplayName = packDisplayName;
        this.skinDisplayName = skinDisplayName;
        this.geometryData = geometryData;
        this.texture = texture;
        this.cape = cape;
    }

    public String getSerializeName() {
        return this.serializeName;
    }

    public String getPackDisplayName() {
        return this.packDisplayName;
    }

    public String getSkinDisplayName() {
        return this.skinDisplayName;
    }

    public JsonObject getGeometryData() {
        return this.geometryData;
    }

    public AssetSource getTexture() {
        return this.texture;
    }

    public AssetSource getCape() {
        return this.cape;
    }

    public String getKey() {
        return this.packDisplayName + ":" + this.skinDisplayName;
    }

    public String getId() {
        return "skinpack." + this.serializeName;
    }

    public String getSafePackName() {
        return StringUtils.sanitize("skinpack." + this.packDisplayName);
    }

    public String getSafeSkinName() {
        return StringUtils.sanitize("skin." + this.packDisplayName + "." + this.skinDisplayName);
    }

    public boolean isInternal() {
        return this.texture instanceof AssetSource.Resource;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public class_2960 getCapeIdentifier() {
        return this.capeIdentifier;
    }
}

