/*
 * Decompiled with CFR 0.152.
 */
package com.brandonitaly.bedrockskins.pack;

import com.brandonitaly.bedrockskins.pack.AssetSource;
import com.brandonitaly.bedrockskins.pack.LoadedSkin;
import com.brandonitaly.bedrockskins.pack.SkinEntry;
import com.brandonitaly.bedrockskins.pack.SkinPackManifest;
import com.brandonitaly.bedrockskins.pack.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public final class SkinPackLoader {
    private static JsonObject vanillaGeometryJson = null;
    private static final Gson gson = new Gson();
    public static final Map<String, LoadedSkin> loadedSkins = Collections.synchronizedMap(new LinkedHashMap());
    private static final File skinPacksDir = new File("skin_packs");
    private static final Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();
    public static List<String> packOrder = Collections.emptyList();

    private SkinPackLoader() {
    }

    public static String getTranslation(String key) {
        String currentLang = "en_us";
        try {
            currentLang = class_310.method_1551().method_1526().method_4669();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<String, String> map = translations.get(currentLang);
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        for (Map<String, String> m : translations.values()) {
            if (!m.containsKey(key)) continue;
            return m.get(key);
        }
        Map<String, String> en = translations.get("en_us");
        return en != null ? en.get(key) : null;
    }

    public static void loadPacks() {
        File[] children;
        loadedSkins.clear();
        translations.clear();
        if (skinPacksDir.exists() && (children = skinPacksDir.listFiles()) != null) {
            for (File f : children) {
                if (!f.isDirectory()) continue;
                SkinPackLoader.loadExternalPack(f);
            }
        }
        class_310 client = null;
        try {
            client = class_310.method_1551();
        }
        catch (Exception e) {
            return;
        }
        if (client == null) {
            return;
        }
        class_3300 manager = client.method_1478();
        SkinPackLoader.loadVanillaGeometry(manager);
        SkinPackLoader.loadInternalPacks(manager);
        SkinPackLoader.loadPackOrder(manager);
    }

    public static void registerTextures() {
        System.out.println("SkinPackLoader: Registering all textures...");
        for (LoadedSkin s : loadedSkins.values()) {
            SkinPackLoader.registerSkinAssets(s);
        }
    }

    public static class_2960 registerTextureFor(String key) {
        LoadedSkin skin = loadedSkins.get(key);
        if (skin == null) {
            return null;
        }
        if (skin.getIdentifier() != null) {
            return skin.getIdentifier();
        }
        SkinPackLoader.registerSkinAssets(skin);
        return skin.getIdentifier();
    }

    public static void registerRemoteSkinStatic(String key, String geometryJson, byte[] textureData) {
        SkinPackLoader.registerRemoteSkin(key, geometryJson, textureData);
    }

    public static void registerRemoteSkin(String key, String geometryJson, byte[] textureData) {
        if (loadedSkins.containsKey(key)) {
            return;
        }
        try {
            if (!SkinPackLoader.validateRemoteData(key, textureData, geometryJson)) {
                return;
            }
            class_1011 img = class_1011.method_4309((InputStream)new ByteArrayInputStream(textureData));
            class_1043 texture = new class_1043(() -> "bedrock_skin_remote", img);
            String safeKey = StringUtils.sanitize(key);
            class_2960 id = class_2960.method_60655((String)"bedrockskins", (String)("skins/remote/" + safeKey));
            class_310.method_1551().method_1531().method_4616(id, (class_1044)texture);
            LoadedSkin ls = new LoadedSkin("Remote", "Remote", key, JsonParser.parseString((String)geometryJson).getAsJsonObject(), AssetSource.Remote.INSTANCE);
            ls.identifier = id;
            loadedSkins.put(key, ls);
            System.out.println("Registered remote skin: " + key);
        }
        catch (Exception e) {
            System.out.println("Failed to register remote skin " + key + ": " + String.valueOf(e));
        }
    }

    private static void loadVanillaGeometry(class_3300 manager) {
        try {
            class_2960 id = class_2960.method_60655((String)"bedrockskins", (String)"skin_packs/vanilla/geometry.json");
            manager.method_14486(id).ifPresent(res -> {
                try (InputStream is = res.method_14482();
                     InputStreamReader r = new InputStreamReader(is);){
                    vanillaGeometryJson = JsonParser.parseReader((Reader)r).getAsJsonObject();
                    System.out.println("SkinPackLoader: Loaded vanilla geometry fallback.");
                }
                catch (Exception e) {
                    System.out.println("SkinPackLoader: ERROR loading vanilla geometry: " + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            System.out.println("SkinPackLoader: ERROR loading vanilla geometry: " + e.getMessage());
        }
    }

    private static void loadExternalPack(File packDir) {
        File skinsFile = new File(packDir, "skins.json");
        if (!skinsFile.exists()) {
            return;
        }
        try {
            JsonObject geometryJson = null;
            File geoFile = new File(packDir, "geometry.json");
            if (geoFile.exists()) {
                geometryJson = JsonParser.parseReader((Reader)new FileReader(geoFile)).getAsJsonObject();
            }
            SkinPackManifest manifest = (SkinPackManifest)gson.fromJson((Reader)new FileReader(skinsFile), SkinPackManifest.class);
            SkinPackLoader.loadExternalTranslations(packDir);
            for (SkinEntry entry : manifest.getSkins()) {
                File capeFile;
                JsonObject geometry = SkinPackLoader.resolveGeometry(entry.getGeometry(), geometryJson);
                if (geometry == null) continue;
                File textureFile = new File(packDir, entry.getTexture());
                File file = capeFile = entry.getCape() != null ? new File(packDir, entry.getCape()) : null;
                if (capeFile != null && !capeFile.exists()) {
                    capeFile = null;
                }
                if (!textureFile.exists()) continue;
                String key = manifest.getLocalizationName() + ":" + entry.getLocalizationName();
                loadedSkins.put(key, new LoadedSkin(manifest.getSerializeName(), manifest.getLocalizationName(), entry.getLocalizationName(), geometry, new AssetSource.File(textureFile.getAbsolutePath()), capeFile != null ? new AssetSource.File(capeFile.getAbsolutePath()) : null));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadInternalPacks(class_3300 manager) {
        System.out.println("SkinPackLoader: Scanning resources...");
        manager.method_14488("skin_packs", idt -> idt.method_12832().endsWith("skins.json")).forEach((id, resource) -> {
            try {
                SkinPackManifest manifest;
                class_2960 geoId = class_2960.method_60655((String)id.method_12836(), (String)id.method_12832().replace("skins.json", "geometry.json"));
                JsonObject geoJson = manager.method_14486(geoId).map(res -> {
                    try (InputStream is = res.method_14482();){
                        JsonObject jsonObject;
                        try (InputStreamReader r = new InputStreamReader(is);){
                            jsonObject = JsonParser.parseReader((Reader)r).getAsJsonObject();
                        }
                        return jsonObject;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }).orElse(null);
                try (InputStream ris = resource.method_14482();
                     InputStreamReader rr = new InputStreamReader(ris);){
                    manifest = (SkinPackManifest)gson.fromJson((Reader)rr, SkinPackManifest.class);
                }
                String packPath = id.method_12832().substring(0, id.method_12832().lastIndexOf(47));
                SkinPackLoader.loadInternalTranslations(manager, id.method_12836(), packPath);
                for (SkinEntry entry : manifest.getSkins()) {
                    class_2960 candidate;
                    class_2960 textureId;
                    JsonObject geometry = SkinPackLoader.resolveGeometry(entry.getGeometry(), geoJson);
                    if (geometry == null || !manager.method_14486(textureId = class_2960.method_60655((String)id.method_12836(), (String)(packPath + "/" + entry.getTexture()).toLowerCase(Locale.ROOT))).isPresent()) continue;
                    class_2960 capeId = null;
                    if (entry.getCape() != null && manager.method_14486(candidate = class_2960.method_60655((String)id.method_12836(), (String)(packPath + "/" + entry.getCape()).toLowerCase(Locale.ROOT))).isPresent()) {
                        capeId = candidate;
                    }
                    String key = manifest.getLocalizationName() + ":" + entry.getLocalizationName();
                    loadedSkins.put(key, new LoadedSkin(manifest.getSerializeName(), manifest.getLocalizationName(), entry.getLocalizationName(), geometry, new AssetSource.Resource(textureId), capeId != null ? new AssetSource.Resource(capeId) : null));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static JsonObject resolveGeometry(String name, JsonObject localGeo) {
        JsonObject raw = SkinPackLoader.findGeometryNode(localGeo, name);
        if (raw == null) {
            raw = SkinPackLoader.findGeometryNode(vanillaGeometryJson, name);
        }
        if (raw == null) {
            return null;
        }
        return SkinPackLoader.wrapGeometry(raw.deepCopy(), name);
    }

    private static JsonObject findGeometryNode(JsonObject json, String name) {
        if (json == null) {
            return null;
        }
        if (json.has(name)) {
            return json.getAsJsonObject(name);
        }
        JsonArray arr = json.getAsJsonArray("minecraft:geometry");
        if (arr != null) {
            for (int i = 0; i < arr.size(); ++i) {
                try {
                    JsonObject geo = arr.get(i).getAsJsonObject();
                    if (geo.getAsJsonObject("description").get("identifier").getAsString().equals(name)) {
                        return geo;
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static JsonObject wrapGeometry(JsonObject content, String name) {
        JsonObject wrapper = new JsonObject();
        wrapper.addProperty("format_version", "1.12.0");
        if (!content.has("description")) {
            JsonObject desc = new JsonObject();
            desc.addProperty("identifier", name);
            int texW = 64;
            int texH = 64;
            try {
                int n = content.has("texturewidth") ? content.get("texturewidth").getAsInt() : (texW = content.has("texture_width") ? content.get("texture_width").getAsInt() : 64);
                texH = content.has("textureheight") ? content.get("textureheight").getAsInt() : (content.has("texture_height") ? content.get("texture_height").getAsInt() : 64);
            }
            catch (Exception exception) {
                // empty catch block
            }
            desc.addProperty("texture_width", (Number)texW);
            desc.addProperty("texture_height", (Number)texH);
            content.add("description", (JsonElement)desc);
        }
        JsonArray arr = new JsonArray();
        arr.add((JsonElement)content);
        wrapper.add("minecraft:geometry", (JsonElement)arr);
        return wrapper;
    }

    private static void registerSkinAssets(LoadedSkin skin) {
        class_1011 capeImg;
        if (skin.identifier != null) {
            return;
        }
        class_1011 img = SkinPackLoader.loadNativeImage(skin.getTexture());
        if (img != null) {
            class_2960 id = class_2960.method_60655((String)"bedrockskins", (String)("skins/" + skin.getSafePackName() + "/" + skin.getSafeSkinName()));
            class_310.method_1551().method_1531().method_4616(id, (class_1044)new class_1043(() -> "bedrock_skin", img));
            skin.identifier = id;
            System.out.println("Registered texture: " + String.valueOf(id));
        }
        if (skin.capeIdentifier == null && skin.getCape() != null && (capeImg = SkinPackLoader.loadNativeImage(skin.getCape())) != null) {
            class_2960 id = class_2960.method_60655((String)"bedrockskins", (String)("capes/" + skin.getSafePackName() + "/" + skin.getSafeSkinName()));
            class_310.method_1551().method_1531().method_4616(id, (class_1044)new class_1043(() -> "bedrock_cape", capeImg));
            skin.capeIdentifier = id;
            System.out.println("Registered texture: " + String.valueOf(id));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static class_1011 loadNativeImage(AssetSource source) {
        try {
            if (source instanceof AssetSource.Resource) {
                class_3298 res = class_310.method_1551().method_1478().method_14486(((AssetSource.Resource)source).getId()).orElse(null);
                if (res == null) {
                    return null;
                }
                try (InputStream is = res.method_14482();){
                    class_1011 class_10112 = class_1011.method_4309((InputStream)is);
                    return class_10112;
                }
            }
            if (!(source instanceof AssetSource.File)) return null;
            try (FileInputStream is = new FileInputStream(new File(((AssetSource.File)source).getPath()));){
                class_1011 class_10113 = class_1011.method_4309((InputStream)is);
                return class_10113;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to load image (" + String.valueOf(source) + "): " + String.valueOf(e));
            return null;
        }
    }

    private static void loadExternalTranslations(File packDir) {
        File texts = new File(packDir, "texts");
        File[] files = texts.listFiles((dir, name) -> name.endsWith(".lang"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            try (FileInputStream is = new FileInputStream(file);){
                SkinPackLoader.parseTranslationStream(is, translations.computeIfAbsent(file.getName().replaceFirst("\\.[^.]+$", "").toLowerCase(Locale.ROOT), k -> new HashMap()));
            }
            catch (Exception e) {
                System.out.println("Error loading translation " + file.getName() + ": " + String.valueOf(e));
            }
        }
    }

    private static void loadInternalTranslations(class_3300 manager, String namespace, String packPath) {
        String clientLang = "en_us";
        try {
            clientLang = class_310.method_1551().method_1526().method_4669().toLowerCase(Locale.ROOT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<String> langs = Arrays.asList(clientLang, "en_us");
        for (String lang : new LinkedHashSet<String>(langs)) {
            class_2960 id = class_2960.method_60655((String)namespace, (String)(packPath + "/texts/" + lang + ".lang"));
            manager.method_14486(id).ifPresent(res -> {
                try (InputStream is = res.method_14482();){
                    SkinPackLoader.parseTranslationStream(is, translations.computeIfAbsent(lang, k -> new HashMap()));
                }
                catch (Exception e) {
                    System.out.println("Error loading internal translation " + String.valueOf(id) + ": " + String.valueOf(e));
                }
            });
        }
    }

    private static void parseTranslationStream(InputStream input, Map<String, String> map) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line;
            reader.mark(1);
            int first = reader.read();
            if (first != 65279) {
                reader.reset();
            }
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split("=", 2);
                if (parts.length != 2) continue;
                String key = parts[0].trim().toLowerCase(Locale.ROOT);
                String val = parts[1].split("\\t#")[0].trim();
                map.put(key, val);
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing translation stream: " + String.valueOf(e));
        }
    }

    private static void loadPackOrder(class_3300 manager) {
        try {
            manager.method_14486(class_2960.method_60655((String)"bedrockskins", (String)"order_overrides.json")).ifPresent(res -> {
                try (InputStream is = res.method_14482();){
                    String[] arr = (String[])gson.fromJson((Reader)new InputStreamReader(is), String[].class);
                    packOrder = Arrays.asList(arr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean validateRemoteData(String key, byte[] data, String geo) {
        if (data.length > 524288) {
            return false;
        }
        if (data.length < 4 || data[0] != -119 || data[1] != 80 || data[2] != 78) {
            return false;
        }
        return geo.length() <= 100000;
    }
}

