/*
 * Decompiled with CFR 0.152.
 */
package net.ray.blockpreview.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_310;

public class SimpleConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "blockpreview-config.json";
    private static ConfigData config = new ConfigData();

    public static void load() {
        block8: {
            try {
                Path configPath = SimpleConfig.getConfigPath();
                if (Files.exists(configPath, new LinkOption[0])) {
                    try (FileReader reader = new FileReader(configPath.toFile());){
                        config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                        break block8;
                    }
                }
                SimpleConfig.save();
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
            }
        }
    }

    public static void save() {
        try {
            Path configPath = SimpleConfig.getConfigPath();
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    private static Path getConfigPath() {
        return class_310.method_1551().field_1697.toPath().resolve("config").resolve(CONFIG_FILE_NAME);
    }

    public static boolean showAllBlocks() {
        return SimpleConfig.config.allBlocks;
    }

    public static void toggleBlockFilter() {
        SimpleConfig.config.allBlocks = !SimpleConfig.config.allBlocks;
        SimpleConfig.save();
    }

    public static class ConfigData {
        public boolean allBlocks = true;
    }
}

