/*
 * Decompiled with CFR 0.152.
 */
package net.ray.blockpreview;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.ray.blockpreview.BlockPreviewKeybinds;
import net.ray.blockpreview.PreviewManager;

@EventBusSubscriber(modid="blockpreview", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class InputHandler {
    private static boolean wasToggleKeyDown = false;
    private static boolean wasHoldKeyDown = false;
    private static boolean wasFilterKeyDown = false;

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        InputHandler.handleToggleKey();
        InputHandler.handleHoldKey();
        InputHandler.handleFilterKey();
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Post event) {
        InputHandler.handleToggleKey();
        InputHandler.handleHoldKey();
        InputHandler.handleFilterKey();
    }

    private static void handleToggleKey() {
        boolean isToggleKeyDown = BlockPreviewKeybinds.TOGGLE_PREVIEW.isDown();
        if (isToggleKeyDown && !wasToggleKeyDown) {
            PreviewManager.togglePreview();
        }
        wasToggleKeyDown = isToggleKeyDown;
    }

    private static void handleHoldKey() {
        boolean isHoldKeyDown = BlockPreviewKeybinds.HOLD_PREVIEW.isDown();
        PreviewManager.setHoldKeyPressed(isHoldKeyDown);
        wasHoldKeyDown = isHoldKeyDown;
    }

    private static void handleFilterKey() {
        boolean isFilterKeyDown = BlockPreviewKeybinds.TOGGLE_BLOCK_FILTER.isDown();
        if (isFilterKeyDown && !wasFilterKeyDown) {
            PreviewManager.toggleBlockFilter();
        }
        wasFilterKeyDown = isFilterKeyDown;
    }
}

