/*
 * Decompiled with CFR 0.152.
 */
package net.ray.blockpreview;

import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.ray.blockpreview.config.SimpleConfig;

public class PreviewManager {
    private static boolean toggleState = true;
    private static boolean holdKeyPressed = false;

    public static void togglePreview() {
        toggleState = !toggleState;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            String status = toggleState ? "\u00a7aON" : "\u00a7cOFF";
            mc.player.displayClientMessage((Component)Component.literal((String)("\u00a7bToggle Preview \u00a77- " + status)), true);
        }
    }

    public static void setHoldKeyPressed(boolean pressed) {
        holdKeyPressed = pressed;
    }

    public static void toggleBlockFilter() {
        SimpleConfig.toggleBlockFilter();
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            String mode = SimpleConfig.showAllBlocks() ? "\u00a7aALL BLOCKS" : "\u00a76FACING ONLY";
            mc.player.displayClientMessage((Component)Component.literal((String)("\u00a7bBlock Filter \u00a77- " + mode)), true);
        }
    }

    public static boolean shouldShowPreview(ItemStack heldItem) {
        boolean shouldShow;
        boolean bl = shouldShow = toggleState || holdKeyPressed;
        if (!shouldShow) {
            return false;
        }
        Item item = heldItem.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        if (SimpleConfig.showAllBlocks()) {
            return true;
        }
        return PreviewManager.hasFacingProperty(blockItem.getBlock().defaultBlockState());
    }

    private static boolean hasFacingProperty(BlockState state) {
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            return true;
        }
        return state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING);
    }
}

