/*
 * Decompiled with CFR 0.152.
 */
package net.ray.blockpreview.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.ray.blockpreview.PreviewManager;
import net.ray.blockpreview.util.RenderHelper;

public class BlockPreviewRenderer {
    private static BlockPos lastPreviewPos = null;
    private static List<BlockState> lastPreviewStates = new ArrayList<BlockState>();
    private static List<BlockPos> lastPreviewPositions = new ArrayList<BlockPos>();

    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        ItemStack heldItem = mc.player.getMainHandItem();
        if (!PreviewManager.shouldShowPreview(heldItem)) {
            lastPreviewPos = null;
            lastPreviewStates.clear();
            lastPreviewPositions.clear();
            return;
        }
        HitResult hitResult = mc.hitResult;
        if (hitResult == null || hitResult.getType() != HitResult.Type.BLOCK) {
            lastPreviewPos = null;
            lastPreviewStates.clear();
            lastPreviewPositions.clear();
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hitResult;
        BlockPos hitPos = blockHit.getBlockPos();
        BlockState hitBlockState = mc.level.getBlockState(hitPos);
        BlockPos placementPos = hitBlockState.canBeReplaced() ? hitPos : hitPos.relative(blockHit.getDirection());
        if (!mc.level.getBlockState(placementPos).canBeReplaced()) {
            lastPreviewPos = null;
            lastPreviewStates.clear();
            lastPreviewPositions.clear();
            return;
        }
        BlockState previewState = BlockPreviewRenderer.getBlockStateFromMinecraftLogic((BlockItem)heldItem.getItem(), blockHit, mc);
        lastPreviewPos = placementPos;
        lastPreviewStates.clear();
        lastPreviewPositions.clear();
        lastPreviewStates.add(previewState);
        lastPreviewPositions.add(placementPos);
        Block block = ((BlockItem)heldItem.getItem()).getBlock();
        BlockPos upperPos = placementPos.above();
        if (mc.level.getBlockState(upperPos).canBeReplaced() && !(block instanceof SlabBlock) && !(block instanceof SnowLayerBlock) && !(block instanceof CarpetBlock)) {
            if (block instanceof DoorBlock) {
                BlockState upperDoorState = (BlockState)previewState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
                lastPreviewStates.add(upperDoorState);
                lastPreviewPositions.add(upperPos);
            } else if (block instanceof DoublePlantBlock || block instanceof TallFlowerBlock) {
                BlockState upperPlantState = (BlockState)previewState.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
                lastPreviewStates.add(upperPlantState);
                lastPreviewPositions.add(upperPos);
            }
        }
    }

    private static BlockState getBlockStateFromMinecraftLogic(BlockItem blockItem, BlockHitResult blockHit, Minecraft mc) {
        try {
            BlockPlaceContext placeContext = new BlockPlaceContext((Level)mc.level, (Player)mc.player, InteractionHand.MAIN_HAND, mc.player.getMainHandItem(), blockHit);
            BlockState state = blockItem.getBlock().getStateForPlacement(placeContext);
            if (state == null) {
                state = blockItem.getBlock().defaultBlockState();
            }
            return state;
        }
        catch (Exception e) {
            return blockItem.getBlock().defaultBlockState();
        }
    }

    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (lastPreviewStates.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        for (int i = 0; i < lastPreviewStates.size(); ++i) {
            BlockState state = lastPreviewStates.get(i);
            BlockPos pos = lastPreviewPositions.get(i);
            poseStack.pushPose();
            poseStack.translate((double)pos.getX() - mc.getEntityRenderDispatcher().camera.getPosition().x, (double)pos.getY() - mc.getEntityRenderDispatcher().camera.getPosition().y, (double)pos.getZ() - mc.getEntityRenderDispatcher().camera.getPosition().z);
            RenderHelper.renderGhostBlock(poseStack, state, pos, mc);
            poseStack.popPose();
        }
    }
}

