/*
 * Decompiled with CFR 0.152.
 */
package net.ray.blockpreview;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.ray.blockpreview.BlockPreviewKeybinds;
import net.ray.blockpreview.PreviewManager;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InputHandler {
    private static boolean wasToggleKeyDown = false;
    private static boolean wasHoldKeyDown = false;
    private static boolean wasFilterKeyDown = false;

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        InputHandler.handleToggleKey();
        InputHandler.handleHoldKey();
        InputHandler.handleFilterKey();
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton event) {
        InputHandler.handleToggleKey();
        InputHandler.handleHoldKey();
        InputHandler.handleFilterKey();
    }

    private static void handleToggleKey() {
        boolean isToggleKeyDown = BlockPreviewKeybinds.TOGGLE_PREVIEW.m_90857_();
        if (isToggleKeyDown && !wasToggleKeyDown) {
            PreviewManager.togglePreview();
        }
        wasToggleKeyDown = isToggleKeyDown;
    }

    private static void handleHoldKey() {
        boolean isHoldKeyDown = BlockPreviewKeybinds.HOLD_PREVIEW.m_90857_();
        PreviewManager.setHoldKeyPressed(isHoldKeyDown);
        wasHoldKeyDown = isHoldKeyDown;
    }

    private static void handleFilterKey() {
        boolean isFilterKeyDown = BlockPreviewKeybinds.TOGGLE_BLOCK_FILTER.m_90857_();
        if (isFilterKeyDown && !wasFilterKeyDown) {
            PreviewManager.toggleBlockFilter();
        }
        wasFilterKeyDown = isFilterKeyDown;
    }
}

