/*
 * Decompiled with CFR 0.152.
 */
package net.ray.blockpreview.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.ray.blockpreview.PreviewManager;
import net.ray.blockpreview.util.RenderHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class BlockPreviewRenderer {
    private static BlockPos lastPreviewPos = null;
    private static List<BlockState> lastPreviewStates = new ArrayList<BlockState>();
    private static List<BlockPos> lastPreviewPositions = new ArrayList<BlockPos>();

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (!PreviewManager.shouldShowPreview(heldItem)) {
            lastPreviewPos = null;
            lastPreviewStates.clear();
            lastPreviewPositions.clear();
            return;
        }
        HitResult hitResult = mc.f_91077_;
        if (hitResult == null || hitResult.m_6662_() != HitResult.Type.BLOCK) {
            lastPreviewPos = null;
            lastPreviewStates.clear();
            lastPreviewPositions.clear();
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hitResult;
        BlockPos hitPos = blockHit.m_82425_();
        BlockState hitBlockState = mc.f_91073_.m_8055_(hitPos);
        BlockPos placementPos = hitBlockState.m_247087_() ? hitPos : hitPos.m_121945_(blockHit.m_82434_());
        if (!mc.f_91073_.m_8055_(placementPos).m_247087_()) {
            lastPreviewPos = null;
            lastPreviewStates.clear();
            lastPreviewPositions.clear();
            return;
        }
        BlockState previewState = BlockPreviewRenderer.getBlockStateFromMinecraftLogic((BlockItem)heldItem.m_41720_(), blockHit, mc);
        lastPreviewPos = placementPos;
        lastPreviewStates.clear();
        lastPreviewPositions.clear();
        lastPreviewStates.add(previewState);
        lastPreviewPositions.add(placementPos);
        Block block = ((BlockItem)heldItem.m_41720_()).m_40614_();
        BlockPos upperPos = placementPos.m_7494_();
        if (mc.f_91073_.m_8055_(upperPos).m_247087_() && !(block instanceof SlabBlock) && !(block instanceof SnowLayerBlock) && !(block instanceof CarpetBlock)) {
            if (block instanceof DoorBlock) {
                BlockState upperDoorState = (BlockState)previewState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER);
                lastPreviewStates.add(upperDoorState);
                lastPreviewPositions.add(upperPos);
            } else if (block instanceof DoublePlantBlock || block instanceof TallFlowerBlock) {
                BlockState upperPlantState = (BlockState)previewState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                lastPreviewStates.add(upperPlantState);
                lastPreviewPositions.add(upperPos);
            }
        }
    }

    private static BlockState getBlockStateFromMinecraftLogic(BlockItem blockItem, BlockHitResult blockHit, Minecraft mc) {
        try {
            BlockPlaceContext placeContext = new BlockPlaceContext((Level)mc.f_91073_, (Player)mc.f_91074_, InteractionHand.MAIN_HAND, mc.f_91074_.m_21205_(), blockHit);
            BlockState state = blockItem.m_40614_().m_5573_(placeContext);
            if (state == null) {
                state = blockItem.m_40614_().m_49966_();
            }
            return state;
        }
        catch (Exception e) {
            return blockItem.m_40614_().m_49966_();
        }
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (lastPreviewStates.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        for (int i = 0; i < lastPreviewStates.size(); ++i) {
            BlockState state = lastPreviewStates.get(i);
            BlockPos pos = lastPreviewPositions.get(i);
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos.m_123341_() - mc.m_91290_().f_114358_.m_90583_().f_82479_, (double)pos.m_123342_() - mc.m_91290_().f_114358_.m_90583_().f_82480_, (double)pos.m_123343_() - mc.m_91290_().f_114358_.m_90583_().f_82481_);
            RenderHelper.renderGhostBlock(poseStack, state, pos, mc);
            poseStack.m_85849_();
        }
    }
}

