/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.capabilities;

import net.minecraft.nbt.CompoundTag;
import net.saksolm.monsterexpansion.capabilities.IPlayerStun;

public class PlayerStunImpl
implements IPlayerStun {
    private int stunValue;
    private int decayTimer;
    private static final int MAX_STUN = 100;
    private static final int DECAY_DELAY = 60;

    @Override
    public int getStunValue() {
        return this.stunValue;
    }

    @Override
    public void setStunValue(int value) {
        this.stunValue = Math.max(0, Math.min(value, 100));
        this.decayTimer = 60;
    }

    @Override
    public void addStun(int amount) {
        this.stunValue = Math.min(this.stunValue + amount, 100);
        this.decayTimer = 60;
    }

    @Override
    public void tick() {
        if (this.stunValue > 0) {
            if (this.decayTimer > 0) {
                --this.decayTimer;
            } else {
                --this.stunValue;
            }
        }
    }

    @Override
    public void copyFrom(IPlayerStun source) {
        this.stunValue = source.getStunValue();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("stun", this.stunValue);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stunValue = nbt.m_128451_("stun");
    }
}

