/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;

public class SetAbilityCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"monsterability").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"abilityName", (ArgumentType)StringArgumentType.word()).executes(SetAbilityCommand::execute))));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        String abilityName = StringArgumentType.getString(context, (String)"abilityName");
        int successCount = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof AbstractLargeMonster)) continue;
            AbstractLargeMonster monster = (AbstractLargeMonster)entity;
            E[] abilities = ((Enum)monster.getNoneAbility()).getDeclaringClass().getEnumConstants();
            boolean found = false;
            for (Object obj : abilities) {
                Enum abilityEnum = (Enum)obj;
                if (!abilityEnum.name().equalsIgnoreCase(abilityName)) continue;
                monster.setCurrentAbility(abilityEnum);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Set ability of " + entity.m_7755_().getString() + " to " + abilityEnum.name())), true);
                ++successCount;
                found = true;
                break;
            }
            if (found) continue;
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Ability '" + abilityName + "' not found for " + entity.m_6095_().m_20675_())));
        }
        return successCount;
    }
}

