/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.effect;

import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class FrostveinEffect
extends MobEffect {
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("8f2b4e8d-8a5e-4b0f-8b1a-3e8e1d7a3d0f");
    private static final UUID ATTACK_SPEED_MODIFIER_UUID = UUID.fromString("c4a3b2e7-8b0c-4e1a-9f2b-8a1d7c3b2e7d");

    public FrostveinEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6385_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        AttributeInstance attackInstance;
        int effectiveAmplifier = Math.min(pAmplifier, 3);
        double slowAmount = -0.1 - (double)effectiveAmplifier * 0.2;
        AttributeInstance moveInstance = pAttributeMap.m_22146_(Attributes.f_22279_);
        if (moveInstance != null) {
            moveInstance.m_22125_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Frostvein movement slow", slowAmount, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if ((attackInstance = pAttributeMap.m_22146_(Attributes.f_22283_)) != null) {
            attackInstance.m_22125_(new AttributeModifier(ATTACK_SPEED_MODIFIER_UUID, "Frostvein attack slow", slowAmount, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        super.m_6385_(pLivingEntity, pAttributeMap, pAmplifier);
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        AttributeInstance moveInstance = pAttributeMap.m_22146_(Attributes.f_22279_);
        AttributeInstance attackInstance = pAttributeMap.m_22146_(Attributes.f_22283_);
        if (moveInstance != null) {
            moveInstance.m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
        }
        if (attackInstance != null) {
            attackInstance.m_22120_(ATTACK_SPEED_MODIFIER_UUID);
        }
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        Vec3 velocity = pLivingEntity.m_20184_();
        if (velocity.f_82480_ > 0.1) {
            int effectiveAmplifier = Math.min(pAmplifier, 3);
            double reduction = 1.0 - (0.1 + (double)effectiveAmplifier * 0.05);
            pLivingEntity.m_20334_(velocity.f_82479_, velocity.f_82480_ * reduction, velocity.f_82481_);
        }
    }
}

