/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.StunFlagPacket;
import net.saksolm.monsterexpansion.particles.ModParticles;

public class StunnedEffect
extends MobEffect {
    private static final String SPEED_MODIFIER_UUID = "7107DE5E-7CE8-4030-940E-514C1F160890";

    public StunnedEffect(MobEffectCategory category, int color) {
        super(category, color);
        this.m_19472_(Attributes.f_22279_, SPEED_MODIFIER_UUID, -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (!entity.m_9236_().m_5776_()) {
            int duration;
            if (entity.m_6117_()) {
                entity.m_5810_();
            }
            entity.m_6858_(false);
            boolean hasSpawnedParticles = entity.getPersistentData().m_128471_("StunParticlesActive");
            MobEffectInstance instance = entity.m_21124_((MobEffect)ModEffects.STUNNED.get());
            int n = duration = instance != null ? instance.m_19557_() : 0;
            if (!hasSpawnedParticles && duration > 0) {
                this.spawnDizzyParticles(entity, duration);
                ModNetwork.sendToClientsTracking(new StunFlagPacket(entity.m_19879_(), true), (Entity)entity);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    ModNetwork.sendToPlayer(new StunFlagPacket(entity.m_19879_(), true), player);
                }
                entity.getPersistentData().m_128379_("StunParticlesActive", true);
            }
            if (duration <= 1) {
                entity.getPersistentData().m_128379_("StunParticlesActive", false);
            }
        }
    }

    private void spawnDizzyParticles(LivingEntity entity, int duration) {
        for (int i = 0; i < 3; ++i) {
            double angleOffset = (double)i * 2.0943951023931953;
            Vec3 encodedData = new Vec3((double)entity.m_19879_(), angleOffset, (double)duration);
            GenericParticlePacket packet = new GenericParticlePacket((ParticleOptions)ModParticles.STUN_STAR.get(), entity.m_20182_(), encodedData, false);
            ModNetwork.sendToClientsTracking(packet, (Entity)entity);
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            ModNetwork.sendToPlayer(packet, player);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

