/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;

public class HighestThreatTargetGoal
extends Goal {
    private final AbstractLargeMonster<?, ?> largeMonster;
    private int checkTimer = 0;

    public HighestThreatTargetGoal(AbstractLargeMonster<?, ?> largeMonster) {
        this.largeMonster = largeMonster;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.checkTimer-- > 0) {
            return false;
        }
        this.checkTimer = 10;
        LivingEntity bestTarget = this.findHighestThreat();
        return bestTarget != null && bestTarget != this.largeMonster.m_5448_();
    }

    public void m_8056_() {
        this.largeMonster.m_6710_(this.findHighestThreat());
    }

    private LivingEntity findHighestThreat() {
        Level level = this.largeMonster.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Map<UUID, Float> permanentThreats = this.largeMonster.getThreatMap();
        Map<UUID, AbstractLargeMonster.ThreatModifier> temporaryThreats = this.largeMonster.getTemporaryThreats();
        HashSet<UUID> allThreatSources = new HashSet<UUID>(permanentThreats.keySet());
        allThreatSources.addAll(temporaryThreats.keySet());
        UUID highestThreatUUID = null;
        float maxThreat = -999.0f;
        for (UUID uuid : allThreatSources) {
            KobekoEntity kobeko;
            Player p;
            LivingEntity living;
            Entity entity;
            float totalThreat = this.largeMonster.getTotalThreat(uuid);
            if (!(totalThreat > maxThreat) || !((entity = serverLevel.m_8791_(uuid)) instanceof LivingEntity) || !(living = (LivingEntity)entity).m_6084_() || living.m_5833_() || living instanceof Player && (p = (Player)living).m_7500_() || living instanceof KobekoEntity && (kobeko = (KobekoEntity)living).isFainted() || this.largeMonster.m_21824_() && this.largeMonster.m_269323_() == living) continue;
            maxThreat = totalThreat;
            highestThreatUUID = uuid;
        }
        if (highestThreatUUID != null) {
            return (LivingEntity)serverLevel.m_8791_(highestThreatUUID);
        }
        return null;
    }
}

