/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;

public class LargeMonsterFollowOwnerGoal
extends Goal {
    private final AbstractLargeMonster<?, ?> abstractLargeMonster;
    private LivingEntity owner;
    private final double speedModifier;
    private Path path;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;

    public LargeMonsterFollowOwnerGoal(AbstractLargeMonster<?, ?> abstractLargeMonster, double speed, float startDistance, float stopDistance) {
        this.abstractLargeMonster = abstractLargeMonster;
        this.speedModifier = speed;
        this.startDistance = startDistance * startDistance;
        this.stopDistance = stopDistance * stopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.abstractLargeMonster.m_21824_() || this.abstractLargeMonster.getTamedStance() != AbstractLargeMonster.TamedStance.FOLLOWING || this.abstractLargeMonster.m_21827_()) {
            return false;
        }
        if (this.abstractLargeMonster.isAttacking()) {
            return false;
        }
        LivingEntity owner = this.abstractLargeMonster.m_269323_();
        if (owner == null) {
            return false;
        }
        if (this.abstractLargeMonster.m_20280_((Entity)owner) < (double)this.startDistance) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        return this.abstractLargeMonster.m_20280_((Entity)this.owner) > (double)this.stopDistance && !this.abstractLargeMonster.isAttacking() && this.abstractLargeMonster.m_269323_() != null;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
    }

    public void m_8041_() {
        this.owner = null;
        this.abstractLargeMonster.m_21573_().m_26573_();
    }

    public void m_8037_() {
        --this.timeToRecalcPath;
        if (this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 20;
            this.path = this.abstractLargeMonster.m_21573_().m_7864_(BlockPos.m_274446_((Position)this.owner.m_20182_()), 0);
            if (this.path.m_77406_() != null && !this.path.m_77392_()) {
                Vec3 finalDestination = this.path.m_77406_().m_252807_();
                double distanceSq = this.abstractLargeMonster.m_20238_(finalDestination);
                AbstractLargeMonster<?, ?> abstractLargeMonster = this.abstractLargeMonster;
                if (abstractLargeMonster instanceof RhyzaEntity) {
                    RhyzaEntity rhyza = (RhyzaEntity)abstractLargeMonster;
                    double RUN_DISTANCE_THRESHOLD_SQ = 400.0;
                    boolean shouldRun = distanceSq > 400.0;
                    rhyza.setRunning(shouldRun);
                    float speed = shouldRun ? 1.5f : 1.0f;
                    rhyza.m_21573_().m_26536_(this.path, (double)speed);
                } else {
                    this.abstractLargeMonster.m_21573_().m_26536_(this.path, this.speedModifier);
                }
            }
        }
    }
}

