/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;

public class SwitchTargetGoal
extends Goal {
    private final AbstractLargeMonster<?, ?> largeMonster;
    private final int switchIntervalBase;
    private int cooldownTimer;

    public SwitchTargetGoal(AbstractLargeMonster<?, ?> largeMonster) {
        this.largeMonster = largeMonster;
        this.cooldownTimer = this.switchIntervalBase = 200;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.cooldownTimer-- > 0) {
            return false;
        }
        this.cooldownTimer = this.switchIntervalBase + this.largeMonster.m_217043_().m_188503_(60);
        return this.largeMonster.m_5448_() != null && !this.getPotentialTargets().isEmpty();
    }

    public void m_8056_() {
        List<LivingEntity> potentialTargets = this.getPotentialTargets();
        if (potentialTargets.isEmpty()) {
            return;
        }
        LivingEntity currentTarget = this.largeMonster.m_5448_();
        LivingEntity newTarget = potentialTargets.get(this.largeMonster.m_217043_().m_188503_(potentialTargets.size()));
        float currentThreat = 0.0f;
        if (currentTarget != null) {
            currentThreat = this.largeMonster.getTotalThreat(currentTarget.m_20148_());
        }
        float newTargetExistingThreat = this.largeMonster.getTotalThreat(newTarget.m_20148_());
        float threatDiff = currentThreat - newTargetExistingThreat;
        float threatToAdd = Math.max(500.0f, threatDiff + 100.0f);
        this.largeMonster.applyTemporaryThreat(newTarget.m_20148_(), threatToAdd, 100);
        System.out.println("SWITCH: Focusing " + newTarget.m_7755_().getString() + " (Added " + threatToAdd + " temp threat)");
    }

    private List<LivingEntity> getPotentialTargets() {
        LivingEntity currentTarget = this.largeMonster.m_5448_();
        return this.largeMonster.m_9236_().m_6443_(LivingEntity.class, this.largeMonster.m_20191_().m_82400_(32.0), entity -> {
            if (entity == this.largeMonster || !entity.m_6084_()) {
                return false;
            }
            if (entity == currentTarget) {
                return false;
            }
            if (this.largeMonster.m_21824_() && entity == this.largeMonster.m_269323_()) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_();
            }
            return entity instanceof KobekoEntity;
        });
    }
}

