/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.behavior;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.saksolm.monsterexpansion.entity.ai.behavior.BehaviorNode;
import net.saksolm.monsterexpansion.entity.ai.behavior.BehaviorStatus;
import net.saksolm.monsterexpansion.entity.ai.behavior.ScoredAction;

public class WeightedSelectorNode<E extends LivingEntity>
implements BehaviorNode<E> {
    private final List<ScoredAction<E>> scoredActions;

    @SafeVarargs
    public WeightedSelectorNode(ScoredAction<E> ... actions) {
        this.scoredActions = Arrays.asList(actions);
    }

    @Override
    public BehaviorStatus tick(E entity) {
        List<ActionScore> candidates = this.scoredActions.stream().map(action -> new ActionScore(action, action.scorer.apply(entity))).filter(as -> as.score > 0.0).toList();
        if (candidates.isEmpty()) {
            return BehaviorStatus.FAILURE;
        }
        double totalWeight = 0.0;
        for (ActionScore candidate : candidates) {
            totalWeight += candidate.score;
        }
        double randomValue = entity.m_217043_().m_188500_() * totalWeight;
        for (ActionScore candidate : candidates) {
            if (!((randomValue -= candidate.score) <= 0.0)) continue;
            return candidate.scoredAction.action.apply(entity);
        }
        return candidates.get((int)(candidates.size() - 1)).scoredAction.action.apply(entity);
    }

    private static class ActionScore<E extends LivingEntity> {
        final ScoredAction<E> scoredAction;
        final double score;

        ActionScore(ScoredAction<E> scoredAction, double score) {
            this.scoredAction = scoredAction;
            this.score = score;
        }
    }
}

