/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.kobeko;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;
import net.saksolm.monsterexpansion.entity.custom.projectile.FlashArrowEntity;

public class KobekoFlashGoal
extends Goal {
    private final KobekoEntity kobeko;
    private LivingEntity target;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public KobekoFlashGoal(KobekoEntity kobeko) {
        this.kobeko = kobeko;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.kobeko.m_5448_() != null && this.kobeko.getCurrentAbility() == KobekoEntity.Ability.FLASH;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.kobeko.getCurrentAbility() == KobekoEntity.Ability.FLASH;
    }

    public void m_8056_() {
        this.target = this.kobeko.m_5448_();
        this.tickCount = 0;
        this.isExecuting = true;
        this.kobeko.setHoldingWeapon(false);
        this.kobeko.setRotationManual(true);
        this.kobeko.setTargetRotation(this.kobeko.getYawFromDirection(this.target.m_20182_().m_82546_(this.kobeko.m_20182_())), 0.0f, 15, KobekoEntity.TurnDirection.SHORTEST, true);
    }

    public void m_8041_() {
        this.target = null;
        this.kobeko.m_21573_().m_26573_();
        if (this.kobeko.getCurrentAbility() == KobekoEntity.Ability.FLASH) {
            this.kobeko.setCurrentAbility(KobekoEntity.Ability.NONE);
        }
        if (this.kobeko.getTamedBehavior() != KobekoEntity.TamedBehavior.PASSIVE) {
            this.kobeko.setHoldingWeapon(true);
        }
        this.kobeko.setRotationManual(false);
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount == 7) {
            this.throwFlashArrow();
            this.kobeko.m_20256_(this.kobeko.m_20154_().m_82541_().m_82490_(0.5));
        }
        if (this.tickCount > 10) {
            this.isExecuting = false;
        }
    }

    private void throwFlashArrow() {
        if (this.target == null || this.kobeko.m_9236_().m_5776_()) {
            return;
        }
        FlashArrowEntity flashArrow = new FlashArrowEntity(this.kobeko.m_9236_(), (LivingEntity)this.kobeko);
        Vec3 direction = this.target.m_146892_().m_82546_(this.kobeko.m_146892_()).m_82541_().m_82490_((double)0.8f);
        flashArrow.m_6686_(direction.f_82479_, direction.f_82480_ + 5.0, direction.f_82481_, 1.2f, 2.0f);
        this.kobeko.m_9236_().m_7967_((Entity)flashArrow);
    }
}

