/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.kobeko;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;

public class KobekoFollowOwnerGoal
extends Goal {
    private final KobekoEntity kobeko;
    private LivingEntity owner;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float maxDistSqr;
    private final float minDistSqr;
    private float oldWaterCost;

    public KobekoFollowOwnerGoal(KobekoEntity kobeko, double speed, float maxDist, float minDist) {
        this.kobeko = kobeko;
        this.speedModifier = speed;
        this.navigation = kobeko.m_21573_();
        this.maxDistSqr = maxDist * maxDist;
        this.minDistSqr = minDist * minDist;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.kobeko.m_21824_()) {
            return false;
        }
        if (this.kobeko.getTamedStance() != KobekoEntity.TamedStance.FOLLOWING) {
            return false;
        }
        LivingEntity livingentity = this.kobeko.m_269323_();
        if (livingentity == null) {
            return false;
        }
        if (!this.kobeko.m_9236_().m_46749_(livingentity.m_20183_())) {
            return false;
        }
        this.owner = livingentity;
        return this.kobeko.m_20280_((Entity)this.owner) > (double)this.minDistSqr;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return this.kobeko.m_20280_((Entity)this.owner) > (double)this.minDistSqr;
        }
        return this.kobeko.getTamedStance() == KobekoEntity.TamedStance.FOLLOWING;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.kobeko.m_21439_(BlockPathTypes.WATER);
        this.kobeko.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.kobeko.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.kobeko.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.kobeko.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.kobeko.m_20280_((Entity)this.owner) >= (double)this.maxDistSqr) {
                if (this.kobeko.m_5448_() == null) {
                    this.robustTeleport();
                }
            } else {
                this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
            }
        }
    }

    private void robustTeleport() {
        BlockPos ownerPos = this.owner.m_20183_();
        if (this.kobeko.m_9236_().m_46749_(ownerPos)) {
            for (int i = 0; i < 10; ++i) {
                int l;
                int k;
                int j = this.kobeko.m_217043_().m_188503_(5) - 2;
                BlockPos targetFloorPos = ownerPos.m_7918_(j, k = this.kobeko.m_217043_().m_188503_(5) - 2, l = this.kobeko.m_217043_().m_188503_(5) - 2);
                if (!this.isSafeTeleportTarget(targetFloorPos)) continue;
                this.kobeko.m_6021_((double)targetFloorPos.m_123341_() + 0.5, (double)targetFloorPos.m_123342_() + 1.0, (double)targetFloorPos.m_123343_() + 0.5);
                this.navigation.m_26573_();
                return;
            }
        }
    }

    private boolean isSafeTeleportTarget(BlockPos pos) {
        Level level = this.kobeko.m_9236_();
        BlockPos floorPos = pos;
        BlockPos airPos1 = pos.m_7494_();
        BlockPos airPos2 = pos.m_6630_(2);
        BlockPos airPos3 = pos.m_6630_(3);
        return level.m_8055_(floorPos).m_280296_() && !level.m_8055_(airPos1).m_280296_() && !level.m_8055_(airPos2).m_280296_() && !level.m_8055_(airPos3).m_280296_();
    }
}

