/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.kobeko;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;

public class KobekoHealGoal
extends Goal {
    private final KobekoEntity kobeko;
    private LivingEntity owner;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private Phase currentPhase;

    public KobekoHealGoal(KobekoEntity kobeko) {
        this.kobeko = kobeko;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity owner = this.kobeko.m_269323_();
        if (owner == null || owner.m_21224_()) {
            return false;
        }
        return this.kobeko.getCurrentAbility() == KobekoEntity.Ability.HEAL;
    }

    public boolean m_8045_() {
        return this.owner != null && !this.owner.m_21224_() && this.isExecuting && this.kobeko.getCurrentAbility() == KobekoEntity.Ability.HEAL;
    }

    public void m_8056_() {
        this.owner = this.kobeko.m_269323_();
        this.tickCount = 0;
        this.isExecuting = true;
        this.currentPhase = Phase.START;
        this.kobeko.setHealState(KobekoEntity.HealState.START.ordinal());
        this.kobeko.setHoldingWeapon(false);
    }

    public void m_8041_() {
        this.owner = null;
        this.kobeko.m_21573_().m_26573_();
        this.currentPhase = null;
        if (this.kobeko.getCurrentAbility() == KobekoEntity.Ability.HEAL) {
            this.kobeko.setCurrentAbility(KobekoEntity.Ability.NONE);
        }
        this.kobeko.setHealState(KobekoEntity.HealState.NONE.ordinal());
        if (this.kobeko.getTamedBehavior() != KobekoEntity.TamedBehavior.PASSIVE) {
            this.kobeko.setHoldingWeapon(true);
        }
    }

    public void m_8037_() {
        if (this.owner == null) {
            return;
        }
        ++this.tickCount;
        switch (this.currentPhase) {
            case START: {
                if (this.tickCount > 4) {
                    this.currentPhase = Phase.CHARGE;
                    this.kobeko.setHealState(KobekoEntity.HealState.CHARGE.ordinal());
                    this.tickCount = 0;
                }
                if (this.tickCount <= 1) break;
                this.kobeko.m_21573_().m_5624_((Entity)this.owner, 1.5);
                break;
            }
            case CHARGE: {
                this.kobeko.m_21573_().m_5624_((Entity)this.owner, 1.5);
                if (!(this.kobeko.m_20280_((Entity)this.owner) < 25.0)) break;
                this.currentPhase = Phase.THROW;
                this.kobeko.setHealState(KobekoEntity.HealState.THROW.ordinal());
                this.kobeko.m_21573_().m_26573_();
                this.tickCount = 0;
                break;
            }
            case THROW: {
                if (this.tickCount == 2) {
                    this.kobeko.m_20334_(this.kobeko.m_20184_().f_82479_, 0.4, this.kobeko.m_20184_().f_82481_);
                }
                if (this.tickCount == 7) {
                    this.throwPotion();
                }
                if (this.tickCount <= 9) break;
                this.isExecuting = false;
            }
        }
    }

    private void throwPotion() {
        if (this.owner == null || this.kobeko.m_9236_().m_5776_()) {
            return;
        }
        ItemStack potionStack = new ItemStack((ItemLike)Items.f_42739_);
        MobEffectInstance customEffect = new MobEffectInstance(MobEffects.f_19605_, 20, 4);
        PotionUtils.m_43552_((ItemStack)potionStack, List.of(customEffect));
        ThrownPotion thrownPotion = new ThrownPotion(this.kobeko.m_9236_(), (LivingEntity)this.kobeko);
        thrownPotion.m_37446_(potionStack);
        Vec3 direction = this.owner.m_20182_().m_82546_(this.kobeko.m_20182_()).m_82541_().m_82490_(1.0);
        thrownPotion.m_6686_(direction.f_82479_, direction.f_82480_ + 0.2, direction.f_82481_, 0.75f, 1.0f);
        this.kobeko.m_9236_().m_7967_((Entity)thrownPotion);
    }

    private static enum Phase {
        START,
        CHARGE,
        THROW;

    }
}

