/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.leivekilth;

import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.LeivekilthEntity;

public class LeivekilthAirBombardGoal
extends Goal {
    private LeivekilthEntity leivekilth;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private boolean targetBelow = false;
    private Phase currentPhase;

    public LeivekilthAirBombardGoal(LeivekilthEntity leivekilth) {
        this.leivekilth = leivekilth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        return this.leivekilth.m_5448_() != null && this.leivekilth.getCurrentAbility() == LeivekilthEntity.Ability.AIR_BOMBARD;
    }

    public boolean m_8045_() {
        return this.leivekilth.getCurrentAbility() == LeivekilthEntity.Ability.AIR_BOMBARD && this.isExecuting;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.leivekilth.m_20256_(Vec3.f_82478_);
        if (this.leivekilth.m_5448_() == null || !this.leivekilth.m_5448_().m_6084_()) {
            this.m_8041_();
            return;
        }
        Vec3 targetPosition = new Vec3(this.leivekilth.m_5448_().m_20182_().f_82479_, this.leivekilth.m_20182_().f_82480_, this.leivekilth.m_5448_().m_20182_().f_82481_);
        Vec3 vecToTarget = targetPosition.m_82546_(this.leivekilth.m_20182_()).m_82541_();
        double dotProduct = vecToTarget.m_82526_(this.leivekilth.m_20154_());
        if (dotProduct > 0.25) {
            this.currentPhase = Phase.START;
            this.leivekilth.setAirBombardState(LeivekilthEntity.AirBombardState.START.ordinal());
        } else if (this.leivekilth.isPositionOnLeft(targetPosition)) {
            this.currentPhase = Phase.TURN_LEFT;
            this.leivekilth.setAirBombardState(LeivekilthEntity.AirBombardState.TURN_LEFT.ordinal());
        } else {
            this.currentPhase = Phase.TURN_RIGHT;
            this.leivekilth.setAirBombardState(LeivekilthEntity.AirBombardState.TURN_RIGHT.ordinal());
        }
        this.leivekilth.setRotationManual(true);
        this.targetBelow = false;
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.leivekilth.m_20256_(Vec3.f_82478_);
        this.currentPhase = null;
        if (this.leivekilth.getCurrentAbility() == LeivekilthEntity.Ability.AIR_BOMBARD) {
            this.leivekilth.setRotationManual(false);
            this.leivekilth.setCurrentAbility(LeivekilthEntity.Ability.NONE);
        }
        this.leivekilth.setAirBombardState(LeivekilthEntity.AirBombardState.NONE.ordinal());
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case TURN_LEFT: {
                if (this.tickCount == 1) {
                    this.leivekilth.setTargetRotation(this.leivekilth.getPredictedAngle(1), 0.0f, 20, AbstractLargeMonster.TurnDirection.LEFT, true);
                }
                if (this.tickCount < 15) break;
                this.currentPhase = Phase.START;
                this.leivekilth.setAirBombardState(LeivekilthEntity.AirBombardState.START.ordinal());
                this.tickCount = 0;
                break;
            }
            case TURN_RIGHT: {
                if (this.tickCount == 1) {
                    this.leivekilth.setTargetRotation(this.leivekilth.getPredictedAngle(1), 0.0f, 20, AbstractLargeMonster.TurnDirection.RIGHT, true);
                }
                if (this.tickCount < 15) break;
                this.currentPhase = Phase.START;
                this.leivekilth.setAirBombardState(LeivekilthEntity.AirBombardState.START.ordinal());
                this.tickCount = 0;
                break;
            }
            case START: {
                if (this.tickCount % 5 == 0 && this.tickCount > 15) {
                    this.leivekilth.spawnBombardmentGlobs();
                }
                if (this.tickCount == 1) {
                    this.leivekilth.startTrackingEntity(this.leivekilth.m_5448_(), 150, 2.5f);
                }
                if (this.tickCount >= 7) {
                    this.leivekilth.m_20256_(this.leivekilth.m_20154_().m_82541_().m_82490_(0.5));
                }
                if (this.tickCount < 25) break;
                this.currentPhase = Phase.GLIDE;
                this.leivekilth.setAirBombardState(LeivekilthEntity.AirBombardState.GLIDE.ordinal());
                this.tickCount = 0;
                break;
            }
            case GLIDE: {
                if (this.tickCount % 5 == 0) {
                    this.leivekilth.spawnBombardmentGlobs();
                }
                this.leivekilth.m_20256_(this.leivekilth.m_20154_().m_82541_().m_82490_(0.5));
                if (this.leivekilth.isTargetInOrientedBox(this.leivekilth.m_5448_(), new Vec3(0.0, -5.0, 0.0), 8.0, 30.0, 8.0)) {
                    this.leivekilth.stopTracking();
                    this.targetBelow = true;
                }
                if (this.targetBelow && this.tickCount >= 20) {
                    this.currentPhase = Phase.STOP;
                    this.leivekilth.setAirBombardState(LeivekilthEntity.AirBombardState.STOP.ordinal());
                    this.tickCount = 0;
                }
                if (this.tickCount < 60) break;
                this.currentPhase = Phase.STOP;
                this.leivekilth.setAirBombardState(LeivekilthEntity.AirBombardState.STOP.ordinal());
                this.tickCount = 0;
                break;
            }
            case STOP: {
                if (this.tickCount < 7) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        TURN_LEFT,
        TURN_RIGHT,
        START,
        GLIDE,
        STOP;

    }
}

