/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.leivekilth;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.LeivekilthEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class LeivekilthTailCutGoal
extends Goal {
    private LeivekilthEntity leivekilth;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private Phase currentPhase;

    public LeivekilthTailCutGoal(LeivekilthEntity leivekilth) {
        this.leivekilth = leivekilth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.leivekilth.getCurrentStaggerState() == LeivekilthEntity.StaggerState.TAIL_CUT;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.leivekilth.getCurrentStaggerState() == LeivekilthEntity.StaggerState.TAIL_CUT;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.leivekilth.m_21573_().m_26573_();
        this.leivekilth.m_20256_(Vec3.f_82478_);
        this.leivekilth.setRotationManual(true);
        this.leivekilth.setCurrentAbility(LeivekilthEntity.Ability.STAGGER);
        if (this.leivekilth.isAerial()) {
            this.currentPhase = Phase.START;
            this.leivekilth.setAirTailCutState(LeivekilthEntity.AirTailCutState.START.ordinal());
        } else {
            this.currentPhase = null;
        }
        this.leivekilth.m_9236_().m_6263_(null, this.leivekilth.m_20185_(), this.leivekilth.m_20186_(), this.leivekilth.m_20189_(), (SoundEvent)ModSounds.LEIVEKILTH_TAIL_CUT.get(), this.leivekilth.m_5720_(), 2.0f, 1.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.leivekilth.m_20256_(Vec3.f_82478_);
        if (this.leivekilth.getCurrentStaggerState() == LeivekilthEntity.StaggerState.TAIL_CUT) {
            this.leivekilth.setCurrentAbility(LeivekilthEntity.Ability.NONE);
            this.leivekilth.setCurrentStaggerState(LeivekilthEntity.StaggerState.NONE);
            this.leivekilth.setRotationManual(false);
        }
        this.leivekilth.setAirTailCutState(LeivekilthEntity.AirTailCutState.NONE.ordinal());
        this.currentPhase = null;
        this.leivekilth.disableFly();
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.currentPhase == null) {
            if (this.tickCount < 15) {
                this.leivekilth.m_20256_(this.leivekilth.m_20154_().m_82541_().m_82490_(0.5));
            }
            if (this.tickCount == 20) {
                this.leivekilth.setTargetRotation(this.leivekilth.f_20883_ + 180.0f, 0.0f, 30, AbstractLargeMonster.TurnDirection.RIGHT, true);
            }
            if (this.tickCount == 40) {
                this.isExecuting = false;
            }
        } else {
            switch (this.currentPhase) {
                case START: {
                    if (this.tickCount > 7) {
                        this.leivekilth.m_20256_(this.leivekilth.m_20184_().m_82549_(new Vec3(0.0, -0.1, 0.0)));
                    }
                    if (this.tickCount <= 10) break;
                    this.currentPhase = Phase.FALL;
                    this.leivekilth.setAirTailCutState(LeivekilthEntity.AirTailCutState.FALL.ordinal());
                    this.tickCount = 0;
                    break;
                }
                case FALL: {
                    this.leivekilth.m_20256_(this.leivekilth.m_20184_().m_82549_(new Vec3(0.0, -0.2, 0.0)));
                    this.leivekilth.m_20256_(new Vec3(0.0, -2.0, 0.0));
                    BlockPos posBelow = this.leivekilth.m_20183_().m_6625_(1);
                    if (this.leivekilth.m_9236_().m_8055_(posBelow).m_60795_()) break;
                    this.currentPhase = Phase.CRASH;
                    this.leivekilth.setAirTailCutState(LeivekilthEntity.AirTailCutState.CRASH.ordinal());
                    this.tickCount = 0;
                    break;
                }
                case CRASH: {
                    if (this.tickCount == 1) {
                        this.leivekilth.m_9236_().m_6263_(null, this.leivekilth.m_20185_(), this.leivekilth.m_20186_(), this.leivekilth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.leivekilth.m_5720_(), 2.0f, 1.0f);
                        this.leivekilth.spawnGroundEffects(Vec3.f_82478_, 5.0f, 5, 5, 1);
                    }
                    if (this.tickCount <= 30) break;
                    this.isExecuting = false;
                }
            }
        }
    }

    private static enum Phase {
        START,
        FALL,
        CRASH;

    }
}

