/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.leivekilth;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.LeivekilthEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class LeivekilthTurnFlopGoal
extends Goal {
    private LeivekilthEntity leivekilth;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private Vec3 retreatVec = Vec3.f_82478_;
    private Phase currentPhase;

    public LeivekilthTurnFlopGoal(LeivekilthEntity leivekilth) {
        this.leivekilth = leivekilth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.leivekilth.m_5448_() != null && this.leivekilth.getCurrentAbility() == LeivekilthEntity.Ability.TURN_FLOP;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.leivekilth.getCurrentAbility() == LeivekilthEntity.Ability.TURN_FLOP;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.leivekilth.m_21573_().m_26573_();
        this.leivekilth.m_20256_(Vec3.f_82478_);
        this.leivekilth.setRotationManual(true);
        this.currentPhase = Phase.DEFAULT;
        this.leivekilth.setBellyFlopState(LeivekilthEntity.BellyFlopState.NONE.ordinal());
        this.leivekilth.clearActiveDamageParts();
        this.leivekilth.clearHitEntities();
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.leivekilth.m_20256_(Vec3.f_82478_);
        if (this.leivekilth.getCurrentAbility() == LeivekilthEntity.Ability.TURN_FLOP) {
            this.leivekilth.setCurrentAbility(LeivekilthEntity.Ability.NONE);
            this.leivekilth.setRotationManual(false);
        }
        this.currentPhase = null;
        this.leivekilth.setBellyFlopState(LeivekilthEntity.BellyFlopState.NONE.ordinal());
        this.leivekilth.stopTracking();
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case DEFAULT: {
                AttackDefinition attackDefinition;
                if (this.tickCount == 1) {
                    this.retreatVec = this.leivekilth.m_20154_().m_82541_();
                }
                if (this.tickCount > 10 && this.tickCount < 15) {
                    this.leivekilth.m_20256_(this.retreatVec.m_82490_((double)0.7f));
                }
                if (this.tickCount == 7) {
                    attackDefinition = new AttackDefinition.Builder().damage(1.0f).knockback(AbstractLargeMonster.KnockbackType.STANDARD, 3.0).breakShield(200).stun(45).build();
                    this.leivekilth.setActivePartAttack(attackDefinition);
                    this.leivekilth.activateTailParts();
                    this.leivekilth.setTargetRotation(this.leivekilth.f_20883_ + 180.0f, 0.0f, 20, AbstractLargeMonster.TurnDirection.LEFT, true);
                }
                if (this.tickCount >= 19 && this.tickCount < 27 && this.leivekilth.m_5448_() != null && this.leivekilth.m_20280_((Entity)this.leivekilth.m_5448_()) > 49.0) {
                    this.leivekilth.clearActiveDamageParts();
                    this.leivekilth.clearHitEntities();
                    if (this.tickCount == 19) {
                        this.leivekilth.startTrackingEntity(this.leivekilth.m_5448_(), 30, 2.5f);
                        this.leivekilth.m_9236_().m_6263_(null, this.leivekilth.m_20185_(), this.leivekilth.m_20186_(), this.leivekilth.m_20189_(), (SoundEvent)ModSounds.LEIVEKILTH_BELLY_FLOP_FAST.get(), this.leivekilth.m_5720_(), 2.0f, 1.0f);
                    }
                }
                if (this.tickCount >= 19 && this.tickCount < 32) {
                    Vec3 direction = this.leivekilth.m_20154_().m_82541_().m_82490_(1.0).m_82549_(new Vec3(0.0, 0.2, 0.0));
                    if (this.leivekilth.m_5448_() != null && this.leivekilth.m_20280_((Entity)this.leivekilth.m_5448_()) < 16.0) {
                        direction = new Vec3(0.0, 0.2, 0.0);
                    }
                    this.leivekilth.m_20256_(direction);
                }
                if (this.tickCount == 40) {
                    this.leivekilth.spawnGroundEffects(new Vec3(0.0, 0.0, 0.0), 10.0f, 100, 20, 10);
                    this.leivekilth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 0.0), 5.0f, 240);
                    this.leivekilth.m_9236_().m_6263_(null, this.leivekilth.m_20185_(), this.leivekilth.m_20186_(), this.leivekilth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.leivekilth.m_5720_(), 2.0f, 1.0f);
                    attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 3.0).ignoreShield().stun(45).build();
                    this.leivekilth.dealDamageInOrientedBox(this.leivekilth.m_20182_(), new Vec3(0.0, 0.0, 0.0), 20.0, 20.0, 20.0, attackDefinition);
                }
                if (this.tickCount < 45) break;
                if (this.leivekilth.m_21223_() <= this.leivekilth.m_21233_() * 0.5f && (this.leivekilth.getTargetRelativePosition(this.leivekilth.m_5448_()) == AbstractLargeMonster.RelativePosition.FRONT || this.leivekilth.getTargetRelativePosition(this.leivekilth.m_5448_()) == AbstractLargeMonster.RelativePosition.FRONT_RIGHT || this.leivekilth.getTargetRelativePosition(this.leivekilth.m_5448_()) == AbstractLargeMonster.RelativePosition.FRONT_LEFT)) {
                    this.currentPhase = Phase.REFLOP;
                    this.leivekilth.setBellyFlopState(LeivekilthEntity.BellyFlopState.REFLOP.ordinal());
                    this.tickCount = 0;
                    break;
                }
                this.currentPhase = Phase.END;
                this.leivekilth.setBellyFlopState(LeivekilthEntity.BellyFlopState.END.ordinal());
                this.tickCount = 0;
                break;
            }
            case REFLOP: {
                if (this.tickCount == 1 && this.leivekilth.m_5448_() != null) {
                    this.leivekilth.startTrackingEntity(this.leivekilth.m_5448_(), 50, 2.5f);
                    this.leivekilth.m_9236_().m_6263_(null, this.leivekilth.m_20185_(), this.leivekilth.m_20186_(), this.leivekilth.m_20189_(), (SoundEvent)ModSounds.LEIVEKILTH_BELLY_FLOP_FAST.get(), this.leivekilth.m_5720_(), 2.0f, 1.0f);
                }
                if (this.tickCount >= 7 && this.tickCount < 20) {
                    Vec3 direction = this.leivekilth.m_20154_().m_82541_().m_82490_(1.0).m_82549_(new Vec3(0.0, 0.2, 0.0));
                    if (this.leivekilth.m_5448_() != null && this.leivekilth.m_20280_((Entity)this.leivekilth.m_5448_()) < 25.0) {
                        direction = new Vec3(0.0, 0.2, 0.0);
                    }
                    this.leivekilth.m_20256_(direction);
                }
                if (this.tickCount == 28) {
                    this.leivekilth.spawnGroundEffects(new Vec3(0.0, 0.0, 0.0), 10.0f, 100, 20, 10);
                    this.leivekilth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 0.0), 5.0f, 240);
                    this.leivekilth.m_9236_().m_6263_(null, this.leivekilth.m_20185_(), this.leivekilth.m_20186_(), this.leivekilth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.leivekilth.m_5720_(), 2.0f, 1.0f);
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 3.0).ignoreShield().build();
                    this.leivekilth.dealDamageInOrientedBox(this.leivekilth.m_20182_(), new Vec3(0.0, 0.0, 0.0), 20.0, 20.0, 20.0, attackDefinition);
                }
                if (this.tickCount < 30) break;
                this.currentPhase = Phase.END;
                this.leivekilth.setBellyFlopState(LeivekilthEntity.BellyFlopState.END.ordinal());
                this.tickCount = 0;
                break;
            }
            case END: {
                this.leivekilth.m_20256_(Vec3.f_82478_);
                if (this.tickCount < 10) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        DEFAULT,
        REFLOP,
        END;

    }
}

