/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothChargeGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RakothChargeGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.CHARGE;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.CHARGE;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
        this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 10, 10.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.CHARGE) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
        this.rakoth.setRotationManual(false);
    }

    public void m_8037_() {
        Vec3 dir;
        ++this.tickCount;
        if (this.tickCount >= 10 && (this.tickCount + 5) % 10 == 0 && this.tickCount < 60) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.RAKOTH_GALLOP.get(), this.rakoth.m_5720_(), 1.0f, 1.0f);
        }
        if (this.tickCount == 10) {
            if (!this.rakoth.isEnraged()) {
                this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 100, 0.5f);
            } else {
                this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 100, 0.75f);
            }
        }
        if (this.tickCount >= 57 && this.tickCount <= 72) {
            dir = this.rakoth.m_20154_().m_82541_().m_82490_((double)0.4f);
            this.rakoth.m_20334_(dir.f_82479_, this.rakoth.m_20184_().f_82480_, dir.f_82481_);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 0.0), 6.0f, 10, 5, 1);
        }
        if (this.tickCount == 57) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_DRAG.get(), this.rakoth.m_5720_(), 1.3f, 0.9f);
        }
        if (this.tickCount >= 10 && this.tickCount <= 65) {
            dir = this.rakoth.m_20154_().m_82541_().m_82490_(1.0);
            this.rakoth.m_20334_(dir.f_82479_, this.rakoth.m_20184_().f_82480_, dir.f_82481_);
            AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 1.0).breakShield(100).stun(15).build();
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 4.0), 5.0, 8.0, 8.0, attackDefinition);
        }
        if (this.tickCount == 78) {
            this.isExecuting = false;
        }
    }
}

