/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothEnrageGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RakothEnrageGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.wantsToEnrage() && this.rakoth.getCurrentStaggerState() == this.rakoth.getNoneStagger();
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.ENRAGE;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.setCurrentAbility(RakothEntity.Ability.ENRAGE);
        this.rakoth.setWantsToEnrage(false);
        this.rakoth.setEnraged(true);
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
        this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 30, 10.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.ENRAGE) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
        this.rakoth.setRotationManual(false);
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount == 8 || this.tickCount == 13) {
            AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(1.5f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 1.0).breakShield(100).stun(5).build();
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 4.0), 8.0, 8.0, 8.0, attackDefinition);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 4.0), 2.0f, 240);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 4.0), 4.0f, 10, 20, 0);
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_LEG_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount == 13) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.RAKOTH_ENRAGE.get(), this.rakoth.m_5720_(), 5.0f, 1.0f);
            ModNetwork.sendToClientsTracking(new ScreenShakePacket(260, 2), (Entity)this.rakoth);
            this.rakoth.inflictRoar(30.0, 50);
        }
        if (this.tickCount >= 13 && this.tickCount <= 33) {
            ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)ParticleTypes.f_123747_, this.rakoth.getHeadPos(), Vec3.f_82478_, true), (Entity)this.rakoth);
        }
        if (this.tickCount == 40) {
            this.isExecuting = false;
        }
    }
}

