/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;

public class RakothMoveGoal
extends Goal {
    private final RakothEntity rakoth;
    private boolean isExecuting = false;
    private final double speedModifier;
    private final float stopDistanceSqr;
    private int timeoutTicks;

    public RakothMoveGoal(RakothEntity rakoth, double speedModifier, float stopDistance) {
        this.rakoth = rakoth;
        this.speedModifier = speedModifier;
        this.stopDistanceSqr = stopDistance * stopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.rakoth.getCurrentAbility() == RakothEntity.Ability.MOVE;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.MOVE;
    }

    public void m_8056_() {
        this.isExecuting = true;
        this.timeoutTicks = 0;
        LivingEntity target = this.rakoth.m_5448_();
        if (target == null) {
            this.m_8041_();
            return;
        }
        double angle = this.rakoth.m_217043_().m_188500_() * 2.0 * Math.PI;
        double distance = 8.0 + this.rakoth.m_217043_().m_188500_() * 7.0;
        double offsetX = Math.cos(angle) * distance;
        double offsetZ = Math.sin(angle) * distance;
        Vec3 targetPos = target.m_20182_();
        BlockPos dest = BlockPos.m_274561_((double)(targetPos.f_82479_ + offsetX), (double)targetPos.f_82480_, (double)(targetPos.f_82481_ + offsetZ));
        this.rakoth.m_21573_().m_26519_((double)dest.m_123341_(), (double)dest.m_123342_(), (double)dest.m_123343_(), this.speedModifier);
    }

    public void m_8037_() {
        ++this.timeoutTicks;
        LivingEntity target = this.rakoth.m_5448_();
        if (target == null || !target.m_6084_()) {
            this.m_8041_();
            return;
        }
        double distToTargetSqr = this.rakoth.m_20280_((Entity)target);
        if (distToTargetSqr < (double)this.stopDistanceSqr) {
            this.m_8041_();
            return;
        }
        if (this.rakoth.m_21573_().m_26571_()) {
            this.m_8041_();
            return;
        }
        if (this.timeoutTicks > 60) {
            this.m_8041_();
            return;
        }
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_21573_().m_26573_();
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.MOVE) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
    }
}

