/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothRollGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private Phase currentPhase;

    public RakothRollGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.ROLL;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.ROLL;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
        this.rakoth.setRollState(RakothEntity.RollState.START.ordinal());
        this.currentPhase = Phase.START;
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.ROLL) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
        this.rakoth.setRotationManual(false);
        this.rakoth.setRollState(RakothEntity.RollState.NONE.ordinal());
        this.currentPhase = null;
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case START: {
                if (this.tickCount >= 10 && (this.tickCount + 5) % 10 == 0 && this.tickCount < 32) {
                    this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.RAKOTH_GALLOP.get(), this.rakoth.m_5720_(), 1.0f, 1.0f);
                }
                if (this.tickCount > 9) {
                    Vec3 direction = this.rakoth.m_20154_().m_82541_().m_82490_(1.0);
                    this.rakoth.m_20334_(direction.f_82479_, this.rakoth.m_20184_().f_82480_, direction.f_82481_);
                }
                if (this.tickCount == 32) {
                    this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 170, 2.5f);
                }
                if (this.tickCount >= 30 && this.tickCount % 10 == 0 && this.tickCount < 45) {
                    this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.RAKOTH_ROLL.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
                }
                if (this.tickCount > 32) {
                    this.rakoth.spawnGroundEffects(Vec3.f_82478_, 5.0f, 5, 2, 1);
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 1.0).breakShield(200).build();
                    this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 0.0), 6.0, 20.0, 10.0, attackDefinition);
                }
                if (this.tickCount <= 39) break;
                this.rakoth.setRollState(RakothEntity.RollState.ROLL.ordinal());
                this.currentPhase = Phase.ROLL;
                this.tickCount = 0;
                break;
            }
            case ROLL: {
                boolean isWallAhead;
                AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 1.0).breakShield(200).stun(55).build();
                this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 0.0), 6.0, 20.0, 10.0, attackDefinition);
                if (this.tickCount % 8 == 0) {
                    this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.RAKOTH_ROLL.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
                }
                if (this.tickCount == 1) {
                    this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 170, 4.0f);
                }
                this.rakoth.spawnGroundEffects(Vec3.f_82478_, 5.0f, 5, 2, 1);
                Vec3 look = this.rakoth.m_20154_().m_82541_();
                AABB currentBox = this.rakoth.m_20191_();
                AABB detectionBox = currentBox.m_82383_(look.m_82490_(1.0));
                detectionBox = detectionBox.m_165897_(0.1, 0.0, 0.1);
                detectionBox = detectionBox.m_165887_(this.rakoth.m_20186_() + 1.2);
                boolean bl = isWallAhead = !this.rakoth.m_9236_().m_45756_((Entity)this.rakoth, detectionBox);
                if (this.rakoth.f_19862_) {
                    isWallAhead = true;
                }
                if (isWallAhead) {
                    this.rakoth.m_20334_(look.f_82479_ * 0.2, 0.8, look.f_82481_ * 0.2);
                    AABB headBox = this.rakoth.m_20191_();
                    AABB boxAbove = new AABB(headBox.f_82288_, headBox.f_82292_, headBox.f_82290_, headBox.f_82291_, headBox.f_82292_ + 2.0, headBox.f_82293_);
                    boxAbove = boxAbove.m_165897_(0.1, 0.0, 0.1);
                    BlockPos.m_121921_((AABB)boxAbove).forEach(pos -> {
                        BlockState state = this.rakoth.m_9236_().m_8055_(pos);
                        if (!state.m_60795_() && state.m_60800_((BlockGetter)this.rakoth.m_9236_(), pos) >= 0.0f && ForgeEventFactory.getMobGriefingEvent((Level)this.rakoth.m_9236_(), (Entity)this.rakoth)) {
                            this.rakoth.m_9236_().m_46953_(pos, true, (Entity)this.rakoth);
                        }
                    });
                } else {
                    double speed = 1.5;
                    this.rakoth.m_20334_(look.f_82479_ * speed, this.rakoth.m_20184_().f_82480_, look.f_82481_ * speed);
                }
                if (this.tickCount <= 89) break;
                this.rakoth.setRollState(RakothEntity.RollState.END.ordinal());
                this.currentPhase = Phase.END;
                this.tickCount = 0;
                break;
            }
            case END: {
                if (this.tickCount == 7) {
                    this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 1.0).ignoreShield().stun(55).build();
                    this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 2.0), 2.0f, 240);
                    this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 6.0), 2.0f, 240);
                    this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 10.0), 2.0f, 240);
                    this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 2.0), 2.0f, 5, 2, 2);
                    this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 6.0), 2.0f, 5, 2, 2);
                    this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 10.0), 2.0f, 5, 2, 2);
                    this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 2.0), 6.0, 10.0, 6.0, attackDefinition);
                    this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 6.0, 10.0, 6.0, attackDefinition);
                    this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 10.0), 6.0, 10.0, 6.0, attackDefinition);
                    if (!this.rakoth.isTailCut()) {
                        this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 14.0), 2.0f, 240);
                        this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 14.0), 2.0f, 5, 2, 2);
                        this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 14.0), 6.0, 10.0, 6.0, attackDefinition);
                    }
                }
                if (this.tickCount <= 6) {
                    this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_(0.5));
                }
                if (this.tickCount >= 20 && this.tickCount <= 26) {
                    this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_(0.5));
                }
                if (this.tickCount <= 34) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        START,
        ROLL,
        END;

    }
}

