/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothSlamGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private float targetYaw;
    private Phase currentPhase;
    private boolean isExecuting = false;

    public RakothSlamGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.SLAM;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.SLAM;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
        this.targetYaw = this.rakoth.getPredictedAngle(5, this.rakoth.m_5448_());
        Vec3 vecToTarget = this.rakoth.getPredictedTargetPosition(this.rakoth.m_5448_(), 5).m_82546_(this.rakoth.m_20182_()).m_82541_();
        double dotProduct = vecToTarget.m_82526_(this.rakoth.m_20154_());
        if (dotProduct > 0.8) {
            this.currentPhase = Phase.FRONT;
            this.rakoth.setSlamState(RakothEntity.SlamState.FRONT.ordinal());
        } else if (this.rakoth.isPositionOnLeft(this.rakoth.getPredictedTargetPosition(this.rakoth.m_5448_(), 5))) {
            this.rakoth.setSlamState(RakothEntity.SlamState.LEFT.ordinal());
            this.currentPhase = Phase.LEFT;
        } else {
            this.rakoth.setSlamState(RakothEntity.SlamState.RIGHT.ordinal());
            this.currentPhase = Phase.RIGHT;
        }
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.SLAM) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
        this.rakoth.setRotationManual(false);
        this.currentPhase = null;
        this.rakoth.setSlamState(RakothEntity.SlamState.NONE.ordinal());
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case FRONT: {
                if (this.tickCount == 1) {
                    this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_WHOOSH.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
                }
                if (this.tickCount == 14) {
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 0.5).ignoreShield().stun(45).build();
                    this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 4.0), 10.0, 10.0, 10.0, attackDefinition);
                    this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 4.0), 2.0f, 240);
                    this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 4.0), 4.0f, 10, 20, 5);
                    this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
                }
                if (this.tickCount != 25) break;
                this.isExecuting = false;
                break;
            }
            case RIGHT: {
                if (this.tickCount == 3) {
                    this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_WHOOSH.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
                }
                if (this.tickCount == 5) {
                    this.rakoth.setTargetRotation(this.targetYaw, 0.0f, 15, AbstractLargeMonster.TurnDirection.RIGHT, true);
                }
                if (this.tickCount == 18) {
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 0.5).ignoreShield().stun(45).build();
                    this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 4.0), 10.0, 10.0, 10.0, attackDefinition);
                    this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 4.0), 2.0f, 240);
                    this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 4.0), 4.0f, 10, 20, 5);
                    this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
                }
                if (this.tickCount != 30) break;
                this.isExecuting = false;
                break;
            }
            case LEFT: {
                if (this.tickCount == 3) {
                    this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_WHOOSH.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
                }
                if (this.tickCount == 5) {
                    this.rakoth.setTargetRotation(this.targetYaw, 0.0f, 15, AbstractLargeMonster.TurnDirection.LEFT, true);
                }
                if (this.tickCount == 18) {
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 0.5).ignoreShield().stun(45).build();
                    this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 4.0), 10.0, 10.0, 10.0, attackDefinition);
                    this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 6.0), 2.0f, 240);
                    this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 6.0), 4.0f, 10, 20, 5);
                    this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
                }
                if (this.tickCount != 30) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        FRONT,
        RIGHT,
        LEFT;

    }
}

