/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.particles.options.DebrisParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DustParticleOptions;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothSlideGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RakothSlideGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.SLIDE;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.SLIDE;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
        this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.RAKOTH_GROWL_SHORT.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 60, 1.5f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.SLIDE) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
        this.rakoth.setRotationManual(false);
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount >= 3 && this.tickCount <= 7) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_((double)-0.1f));
        }
        if (this.tickCount >= 7 && this.tickCount <= 8) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_(0.5));
        }
        if (this.tickCount == 9) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_DRAG.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount == 8) {
            AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 1.0).breakShield(100).stun(35).build();
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 8.0, 8.0, 8.0, attackDefinition);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 6.0), 2.0f, 240);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 6.0), 4.0f, 10, 20, 5);
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_LEG_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        int debrisCount = 30;
        int dustCount = 30;
        double spawnRadius = 3.0;
        if (this.tickCount == 25) {
            double velZ;
            double velY;
            double velX;
            Object options;
            BlockState groundState;
            BlockPos groundPos;
            Vec3 particleSpawnPos;
            double offsetZ;
            double offsetX;
            double distance;
            double angle;
            int i;
            AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 1.0).breakShield(100).stun(35).build();
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 6.0, 8.0, 6.0, attackDefinition);
            for (i = 0; i < debrisCount; ++i) {
                angle = this.rakoth.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = this.rakoth.m_217043_().m_188500_() * spawnRadius;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                particleSpawnPos = this.rakoth.getHeadPos().m_82549_(new Vec3(0.0, 1.0, 0.0));
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = this.rakoth.m_9236_().m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DebrisParticleOptions(groundState);
                velX = (this.rakoth.m_217043_().m_188500_() - 0.5) * 0.8;
                velY = this.rakoth.m_217043_().m_188500_() * 0.5;
                velZ = (this.rakoth.m_217043_().m_188500_() - 0.5) * 0.8;
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ).m_82549_(this.rakoth.m_20154_().m_82541_().m_82490_(0.25)), true), (Entity)this.rakoth);
            }
            for (i = 0; i < dustCount; ++i) {
                angle = this.rakoth.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = this.rakoth.m_217043_().m_188500_() * spawnRadius;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                particleSpawnPos = this.rakoth.getHeadPos().m_82549_(new Vec3(0.0, 1.0, 0.0));
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = this.rakoth.m_9236_().m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DustParticleOptions(groundState);
                velX = (this.rakoth.m_217043_().m_188500_() - 0.5) * 0.3;
                velY = this.rakoth.m_217043_().m_188500_() * 0.3;
                velZ = (this.rakoth.m_217043_().m_188500_() - 0.5) * 0.3;
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ).m_82549_(this.rakoth.m_20154_().m_82541_().m_82490_(0.25)), true), (Entity)this.rakoth);
            }
        }
        if (this.tickCount >= 9 && this.tickCount <= 25) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_(0.5));
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 4.0), 3.0f, 4, 2, 0);
        }
        if (this.tickCount >= 25 && this.tickCount <= 30) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_((double)0.1f));
        }
        if (this.tickCount == 37) {
            this.isExecuting = false;
        }
    }
}

