/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothSmashGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RakothSmashGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.SMASH;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.SMASH;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
        this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 20, 2.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.SMASH) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
        this.rakoth.setRotationManual(false);
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount >= 6 && this.tickCount <= 10) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_((double)-0.1f));
        }
        if (this.tickCount >= 12 && this.tickCount <= 15) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_(0.5));
        }
        if (this.tickCount == 1) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.RAKOTH_GROWL.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount == 15) {
            AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 1.0).breakShield(100).stun(35).build();
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 8.0, 8.0, 8.0, attackDefinition);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 6.0), 2.0f, 240);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 6.0), 4.0f, 10, 20, 5);
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_LEG_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount == 24 && !this.rakoth.isAbilityEnraged()) {
            this.isExecuting = false;
        }
        if (this.tickCount == 15 && this.rakoth.isAbilityEnraged()) {
            this.isExecuting = false;
        }
    }
}

