/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothSpinGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RakothSpinGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.SPIN;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.SPIN;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.SPIN) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
        this.rakoth.setRotationManual(false);
        this.rakoth.clearHitEntities();
        this.rakoth.clearActiveDamageParts();
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount == 7) {
            AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.STANDARD, 2.0).breakShield(200).stun(35).build();
            this.rakoth.setActivePartAttack(attackDefinition);
            this.rakoth.activateTailParts();
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_WHOOSH.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount == 30) {
            this.rakoth.clearHitEntities();
            this.rakoth.clearActiveDamageParts();
        }
        if (this.tickCount == 35) {
            this.isExecuting = false;
        }
    }
}

