/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.entity.custom.RakothPartEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothTailSlamGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RakothTailSlamGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.TAIL_SLAM;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.TAIL_SLAM;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
        this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 30, 10.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.TAIL_SLAM) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
        this.rakoth.setRotationManual(false);
    }

    public void m_8037_() {
        AttackDefinition attackDefinition;
        ++this.tickCount;
        if (this.tickCount >= 14 && this.tickCount <= 20) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_(1.0));
        }
        if (this.tickCount >= 7 && this.tickCount <= 11) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82541_().m_82490_((double)0.8f));
        }
        if (this.tickCount >= 34 && this.tickCount <= 40) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_(0.5));
        }
        if (this.tickCount == 8) {
            attackDefinition = new AttackDefinition.Builder().damage(1.5f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 1.0).breakShield(100).stun(25).build();
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 4.0), 8.0, 8.0, 8.0, attackDefinition);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 4.0), 2.0f, 240);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 4.0), 4.0f, 10, 20, 5);
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_LEG_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount == 13) {
            attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 0.5).breakShield(100).stun(55).build();
            for (LargeMonsterPartEntity<?> part : this.rakoth.getBodyParts()) {
                if (!this.rakoth.isTailPart((RakothPartEntity)part)) continue;
                this.rakoth.spawnSmashedGroundEffect(part.m_20182_(), new Vec3(0.0, 1.0, 0.0), 2.0f, 240);
                this.rakoth.spawnGroundEffects(part.m_20182_(), new Vec3(0.0, 0.25, 0.0), 2.0f, 20, 5, 1);
                this.rakoth.dealDamageInOrientedBox(part.m_20182_(), new Vec3(0.0, 1.0, 0.0), 4.0, 10.0, 4.0, attackDefinition);
            }
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount == 15) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_WHOOSH.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount == 22) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
            attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 1.0).ignoreShield().build();
            this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 2.0), 2.0f, 240);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 6.0), 2.0f, 240);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 10.0), 2.0f, 240);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 2.0), 2.0f, 5, 2, 2);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 6.0), 2.0f, 5, 2, 2);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 10.0), 2.0f, 5, 2, 2);
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 2.0), 6.0, 10.0, 6.0, attackDefinition);
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 6.0, 10.0, 6.0, attackDefinition);
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 10.0), 6.0, 10.0, 6.0, attackDefinition);
            if (!this.rakoth.isTailCut()) {
                this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 14.0), 2.0f, 240);
                this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 14.0), 2.0f, 5, 2, 2);
                this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 14.0), 6.0, 10.0, 6.0, attackDefinition);
            }
        }
        if (this.tickCount == 50) {
            this.isExecuting = false;
        }
    }
}

