/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.entity.custom.RakothPartEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothTailSweepGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RakothTailSweepGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.TAIL_SWEEP;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.TAIL_SWEEP;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
        this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_WHOOSH.get(), this.rakoth.m_5720_(), 2.0f, 0.9f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.TAIL_SWEEP) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
        this.rakoth.setRotationManual(false);
        this.rakoth.clearActiveDamageParts();
        this.rakoth.clearHitEntities();
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount == 13) {
            AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 0.5).breakShield(200).stun(45).build();
            LargeMonsterPartEntity<?>[] largeMonsterPartEntityArray = this.rakoth.getBodyParts();
            int n = largeMonsterPartEntityArray.length;
            for (int i = 0; i < n; ++i) {
                LargeMonsterPartEntity<?> part = largeMonsterPartEntityArray[i];
                if (!this.rakoth.isTailPart((RakothPartEntity)part)) continue;
                this.rakoth.spawnSmashedGroundEffect(part.m_20182_(), new Vec3(0.0, 1.0, 0.0), 2.0f, 240);
                this.rakoth.spawnGroundEffects(part.m_20182_(), new Vec3(0.0, 0.25, 0.0), 2.0f, 20, 5, 1);
                this.rakoth.dealDamageInOrientedBox(part.m_20182_(), new Vec3(0.0, 1.0, 0.0), 6.0, 10.0, 6.0, attackDefinition);
            }
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount > 18 && this.tickCount < 34) {
            for (LargeMonsterPartEntity<?> part : this.rakoth.getBodyParts()) {
                if (!this.rakoth.isTailPart((RakothPartEntity)part)) continue;
                this.rakoth.spawnGroundEffects(part.m_20182_(), new Vec3(0.0, 1.0, 0.0), 2.0f, 3, 1, 0);
            }
        }
        if (this.tickCount == 18) {
            AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 0.5).breakShield(100).stun(35).build();
            this.rakoth.setActivePartAttack(attackDefinition);
            this.rakoth.activateTailParts();
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_DRAG.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount == 34) {
            this.rakoth.clearActiveDamageParts();
            this.rakoth.clearHitEntities();
        }
        if (this.tickCount == 39) {
            this.isExecuting = false;
        }
    }
}

