/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothTailswipeGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RakothTailswipeGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.TAILSWIPE;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.TAILSWIPE;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.TAILSWIPE) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
        this.rakoth.setRotationManual(false);
        this.rakoth.clearActiveDamageParts();
        this.rakoth.clearHitEntities();
    }

    public void m_8037_() {
        AttackDefinition attackDefinition;
        ++this.tickCount;
        if (this.tickCount >= 5 && this.tickCount <= 12) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_(0.5));
        }
        if (this.tickCount >= 15 && this.tickCount <= 25) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_((double)0.3f));
        }
        if (this.tickCount == 12) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_WHOOSH.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
            attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 0.3f).breakShield(100).stun(35).build();
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(2.0, 0.0, 0.0), 4.0, 8.0, 4.0, attackDefinition);
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(6.0, 0.0, 0.0), 4.0, 8.0, 4.0, attackDefinition);
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(10.0, 0.0, 0.0), 4.0, 8.0, 4.0, attackDefinition);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(-2.0, 0.0, 0.0), 2.0f, 240);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(-6.0, 0.0, 0.0), 2.0f, 240);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(-10.0, 0.0, 0.0), 2.0f, 240);
            this.rakoth.spawnGroundEffects(new Vec3(-2.0, 0.0, 0.0), 2.0f, 10, 5, 1);
            this.rakoth.spawnGroundEffects(new Vec3(-6.0, 0.0, 0.0), 2.0f, 10, 5, 1);
            this.rakoth.spawnGroundEffects(new Vec3(-10.0, 0.0, 0.0), 2.0f, 10, 5, 1);
            if (!this.rakoth.isTailCut()) {
                this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(14.0, 0.0, 0.0), 4.0, 8.0, 4.0, attackDefinition);
                this.rakoth.spawnGroundEffects(new Vec3(-14.0, 0.0, 0.0), 2.0f, 10, 5, 1);
                this.rakoth.spawnSmashedGroundEffect(new Vec3(-14.0, 0.0, 0.0), 2.0f, 240);
            }
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
        }
        if (this.tickCount == 17) {
            attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 0.3f).breakShield(100).stun(35).build();
            this.rakoth.setActivePartAttack(attackDefinition);
            this.rakoth.activateTailParts();
        }
        if (this.tickCount == 35) {
            this.rakoth.clearHitEntities();
            this.rakoth.clearActiveDamageParts();
        }
        if (this.tickCount == 42) {
            this.isExecuting = false;
        }
    }
}

