/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RakothTemperGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RakothTemperGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.m_5448_() != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.TEMPER;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.TEMPER;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.rakoth.setRotationManual(true);
        this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 20, 2.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rakoth.m_20256_(Vec3.f_82478_);
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.TEMPER) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
        }
    }

    public void m_8037_() {
        AttackDefinition attackDefinition;
        ++this.tickCount;
        if (this.tickCount == 2) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.RAKOTH_GROWL_SHORT.get(), this.rakoth.m_5720_(), 2.0f, 0.9f);
        }
        if (this.tickCount >= 10 && this.tickCount <= 12) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_(0.5));
        }
        if (this.tickCount == 13) {
            attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 0.5).breakShield(100).stun(55).build();
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 8.0, 8.0, 8.0, attackDefinition);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 6.0), 2.0f, 240);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 6.0), 4.0f, 10, 20, 5);
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_LEG_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.0f);
            ModNetwork.sendToClientsTracking(new ScreenShakePacket(30, 1), (Entity)this.rakoth);
        }
        if (this.tickCount == 22) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.RAKOTH_GROWL.get(), this.rakoth.m_5720_(), 2.0f, 0.9f);
        }
        if (this.tickCount >= 30 && this.tickCount <= 32) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_((double)0.7f));
        }
        if (this.tickCount == 25) {
            this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 17, 5.0f);
        }
        if (this.tickCount == 33) {
            attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 1.0).breakShield(100).stun(55).build();
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 15.0, 15.0, 15.0, attackDefinition);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 6.0), 3.0f, 240);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 6.0), 7.0f, 50, 50, 10);
            this.rakoth.spawnGroundEffects(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 3.0f, 50, 0, 0, Vec3.f_82478_, 0.1f, 1.5f);
            this.rakoth.spawnGroundEffects(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 4.0f, 0, 25, 0, Vec3.f_82478_, 0.1f, 4.0f);
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.rakoth.m_5720_(), 2.0f, 1.2f);
            ModNetwork.sendToClientsTracking(new ScreenShakePacket(30, 3), (Entity)this.rakoth);
        }
        if (this.tickCount == 55) {
            this.rakoth.startTrackingEntity(this.rakoth.m_5448_(), 17, 5.0f);
        }
        if (this.tickCount == 40) {
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.RAKOTH_GROWL_LONG.get(), this.rakoth.m_5720_(), 3.0f, 0.9f);
        }
        if (this.tickCount >= 60 && this.tickCount <= 62) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_((double)0.8f));
        }
        if (this.tickCount == 63) {
            attackDefinition = new AttackDefinition.Builder().damage(4.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 2.0).breakShield(100).stun(75).build();
            this.rakoth.dealDamageInOrientedBox(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 30.0, 30.0, 30.0, attackDefinition);
            this.rakoth.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 6.0), 5.0f, 240);
            this.rakoth.spawnGroundEffects(new Vec3(0.0, 0.0, 6.0), 15.0f, 100, 50, 20);
            this.rakoth.spawnGroundEffects(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 4.0f, 100, 0, 0, Vec3.f_82478_, 0.1f, 2.0f);
            this.rakoth.spawnGroundEffects(this.rakoth.m_20182_(), new Vec3(0.0, 0.0, 6.0), 4.0f, 0, 50, 0, Vec3.f_82478_, 0.1f, 5.0f);
            this.rakoth.m_9236_().m_6263_(null, this.rakoth.m_20185_(), this.rakoth.m_20186_(), this.rakoth.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.rakoth.m_5720_(), 3.0f, 0.8f);
            ModNetwork.sendToClientsTracking(new ScreenShakePacket(60, 5), (Entity)this.rakoth);
        }
        if (this.tickCount >= 67 && this.tickCount <= 69) {
            this.rakoth.m_20256_(this.rakoth.m_20154_().m_82541_().m_82490_(0.5));
        }
        if (this.tickCount == 84) {
            this.isExecuting = false;
        }
    }
}

