/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rakoth;

import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RakothEntity;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;

public class RakothTurnGoal
extends Goal {
    private RakothEntity rakoth;
    private int tickCount = 0;
    private float targetYaw;
    private boolean isExecuting = false;
    private boolean right;

    public RakothTurnGoal(RakothEntity rakoth) {
        this.rakoth = rakoth;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rakoth.turnTarget != null && this.rakoth.getCurrentAbility() == RakothEntity.Ability.TURN;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rakoth.getCurrentAbility() == RakothEntity.Ability.TURN;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rakoth.m_21573_().m_26573_();
        this.rakoth.setRotationManual(true);
        this.rakoth.m_20256_(Vec3.f_82478_);
        this.targetYaw = this.rakoth.getPredictedAngle(5, this.rakoth.turnTarget);
        if (this.rakoth.isTargetOnLeft(this.rakoth.turnTarget)) {
            this.rakoth.setTurnState(SkrytheEntity.TurnState.LEFT.ordinal());
            this.right = false;
        } else {
            this.rakoth.setTurnState(SkrytheEntity.TurnState.RIGHT.ordinal());
            this.right = true;
        }
    }

    public void m_8041_() {
        this.isExecuting = false;
        if (this.rakoth.getCurrentAbility() == RakothEntity.Ability.TURN) {
            this.rakoth.setCurrentAbility(RakothEntity.Ability.NONE);
            this.rakoth.setRotationManual(false);
        }
        this.rakoth.setTurnState(SkrytheEntity.TurnState.NONE.ordinal());
        this.right = false;
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount == 5) {
            if (this.right) {
                this.rakoth.setTargetRotation(this.targetYaw, 0.0f, 12, AbstractLargeMonster.TurnDirection.RIGHT, true);
            } else {
                this.rakoth.setTargetRotation(this.targetYaw, 0.0f, 12, AbstractLargeMonster.TurnDirection.LEFT, true);
            }
        }
        if (this.tickCount >= 11) {
            this.isExecuting = false;
        }
    }
}

