/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rhyza;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class RhyzaEnrageGoal
extends Goal {
    private RhyzaEntity rhyza;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RhyzaEnrageGoal(RhyzaEntity rhyza) {
        this.rhyza = rhyza;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rhyza.m_5448_() != null && this.rhyza.wantsToEnrage() && this.rhyza.getCurrentStaggerState() == RhyzaEntity.StaggerState.NONE;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.ENRAGE;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rhyza.setEnraged(true);
        this.rhyza.setCurrentAbility(RhyzaEntity.Ability.ENRAGE);
        this.rhyza.m_21573_().m_26573_();
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setRotationManual(true);
        this.rhyza.startTrackingEntity(this.rhyza.m_5448_(), 20, 5.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rhyza.m_20256_(Vec3.f_82478_);
        if (this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.ENRAGE) {
            this.rhyza.setCurrentAbility(RhyzaEntity.Ability.NONE);
        }
        this.rhyza.setWantsToEnrage(false);
        this.rhyza.setRotationManual(false);
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount == 16) {
            this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_ROAR_ENRAGE.get(), this.rhyza.m_5720_(), 5.0f, 1.0f);
            ModNetwork.sendToClientsTracking(new ScreenShakePacket(120, 1), (Entity)this.rhyza);
            this.rhyza.inflictRoar(30.0, 40);
        }
        if (this.tickCount > 1 && this.tickCount <= 10) {
            Vec3 retreatVector = this.rhyza.m_20154_().m_82490_(0.15);
            this.rhyza.m_20256_(retreatVector);
        }
        if (this.tickCount > 16 && this.tickCount <= 25) {
            ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)ParticleTypes.f_123747_, this.rhyza.getHeadPart().m_20182_(), Vec3.f_82478_, true), (Entity)this.rhyza);
        }
        if (this.tickCount > 45) {
            this.isExecuting = false;
        }
    }
}

