/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rhyza;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;
import net.saksolm.monsterexpansion.event.RhyzaSetBonusEvents;
import net.saksolm.monsterexpansion.network.FlashbangSequencePacket;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.SoundPacket;
import net.saksolm.monsterexpansion.particles.ModParticles;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class RhyzaFlashGoal
extends Goal {
    private RhyzaEntity rhyza;
    private int tickCount = 0;
    private final List<ServerPlayer> playersToBlind = Lists.newArrayList();
    public Phase currentPhase;
    private boolean isExecuting = false;

    public RhyzaFlashGoal(RhyzaEntity rhyza) {
        this.rhyza = rhyza;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rhyza.m_5448_() != null && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.FLASH;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.FLASH;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rhyza.m_21573_().m_26573_();
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setRotationManual(true);
        this.playersToBlind.clear();
        this.rhyza.startTrackingEntity(this.rhyza.m_5448_(), 30, 5.0f);
        LivingEntity target = this.rhyza.m_5448_();
        if (target != null) {
            double dotRight;
            Vec3 playerLook = target.m_20252_(1.0f);
            Vec3 playerEyePos = target.m_146892_();
            Vec3 leftDir = this.rhyza.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82541_();
            Vec3 rightDir = leftDir.m_82490_(-1.0);
            Vec3 futurePosLeft = this.rhyza.m_20182_().m_82549_(leftDir.m_82490_(5.0));
            Vec3 futurePosRight = this.rhyza.m_20182_().m_82549_(rightDir.m_82490_(5.0));
            Vec3 toFutureLeft = futurePosLeft.m_82546_(playerEyePos).m_82541_();
            Vec3 toFutureRight = futurePosRight.m_82546_(playerEyePos).m_82541_();
            double dotLeft = playerLook.m_82526_(toFutureLeft);
            this.currentPhase = dotLeft > (dotRight = playerLook.m_82526_(toFutureRight)) ? Phase.LEFT : Phase.RIGHT;
            this.rhyza.setFlashState(dotLeft > dotRight ? RhyzaEntity.FlashState.LEFT.ordinal() : RhyzaEntity.FlashState.RIGHT.ordinal());
        } else {
            this.currentPhase = this.rhyza.m_217043_().m_188499_() ? Phase.LEFT : Phase.RIGHT;
            this.rhyza.setFlashState(this.rhyza.m_217043_().m_188499_() ? RhyzaEntity.FlashState.LEFT.ordinal() : RhyzaEntity.FlashState.RIGHT.ordinal());
        }
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rhyza.m_20256_(Vec3.f_82478_);
        if (this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.FLASH) {
            this.rhyza.setCurrentAbility(RhyzaEntity.Ability.NONE);
        }
        this.rhyza.setRotationManual(false);
        this.playersToBlind.clear();
        this.rhyza.setFlashState(RhyzaEntity.FlashState.NONE.ordinal());
        this.currentPhase = null;
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case LEFT: {
                Vec3 retreatVector;
                if (this.tickCount > 4 && this.tickCount <= 17) {
                    retreatVector = this.rhyza.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82541_();
                    this.rhyza.m_20334_(retreatVector.m_82490_((double)1.0).f_82479_, this.rhyza.m_20184_().f_82480_, retreatVector.m_82490_((double)1.0).f_82481_);
                }
                if (this.tickCount <= 17 || this.tickCount > 25) break;
                retreatVector = this.rhyza.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82541_();
                this.rhyza.m_20334_(retreatVector.m_82490_((double)0.25).f_82479_, this.rhyza.m_20184_().f_82480_, retreatVector.m_82490_((double)0.25).f_82481_);
                break;
            }
            case RIGHT: {
                Vec3 retreatVector;
                if (this.tickCount > 4 && this.tickCount <= 17) {
                    retreatVector = this.rhyza.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82541_();
                    this.rhyza.m_20334_(retreatVector.m_82490_((double)-1.0).f_82479_, this.rhyza.m_20184_().f_82480_, retreatVector.m_82490_((double)-1.0).f_82481_);
                }
                if (this.tickCount <= 17 || this.tickCount > 25) break;
                retreatVector = this.rhyza.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82541_();
                this.rhyza.m_20334_(retreatVector.m_82490_((double)-0.25).f_82479_, this.rhyza.m_20184_().f_82480_, retreatVector.m_82490_((double)-0.25).f_82481_);
            }
        }
        if (this.tickCount > 4 && this.tickCount <= 8) {
            this.rhyza.m_20256_(this.rhyza.m_20184_().m_82549_(new Vec3(0.0, 0.15, 0.0)));
        }
        if (this.tickCount == 1) {
            this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_FLASHBANG_HUM.get(), this.rhyza.m_5720_(), 3.0f, 1.0f);
        }
        if (this.tickCount == 15 && !this.rhyza.isRightTailCut() && !this.rhyza.isLeftTailCut()) {
            Vec3 tailPos = this.rhyza.getTailTipPart().m_20182_();
            SimpleParticleType flashParticle = ParticleTypes.f_123747_;
            ParticleOptions flash = (ParticleOptions)ModParticles.FLASH.get();
            GenericParticlePacket particlePacket = new GenericParticlePacket((ParticleOptions)flashParticle, tailPos, Vec3.f_82478_, true);
            GenericParticlePacket flashParticlePacket = new GenericParticlePacket(flash, tailPos, Vec3.f_82478_, true);
            ModNetwork.sendToClientsTracking(particlePacket, (Entity)this.rhyza);
            ModNetwork.sendToClientsTracking(flashParticlePacket, (Entity)this.rhyza);
        }
        if (this.tickCount == 16 && !this.rhyza.isRightTailCut() && !this.rhyza.isLeftTailCut()) {
            this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_FLASHBANG.get(), this.rhyza.m_5720_(), 5.0f, 1.0f);
            AABB area = this.rhyza.m_20191_().m_82400_(50.0);
            List entities = this.rhyza.m_9236_().m_45976_(LivingEntity.class, area);
            for (LivingEntity entity : entities) {
                if (entity == this.rhyza) continue;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    this.handlePlayerFlash(player);
                    continue;
                }
                if (entity instanceof AbstractLargeMonster) {
                    AbstractLargeMonster largeMonster = (AbstractLargeMonster)entity;
                    largeMonster.flash();
                    continue;
                }
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                mob.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLINDED.get(), 400, 0));
            }
        }
        if (this.tickCount == 25) {
            for (ServerPlayer player : this.playersToBlind) {
                if (!player.m_6084_()) continue;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 400, 0));
            }
            this.rhyza.resetPartOffsets();
        }
        if (this.tickCount == 30) {
            this.isExecuting = false;
        }
    }

    private void handlePlayerFlash(ServerPlayer player) {
        double GUARANTEED_FLASH_RANGE = 2.0;
        double distanceSq = this.rhyza.m_20280_((Entity)player);
        if (distanceSq <= 4.0) {
            this.flashPlayer(player);
            return;
        }
        boolean hasLineOfSight = player.m_142582_((Entity)this.rhyza.getTailTipPart());
        Vec3 playerLookVec = player.m_20252_(1.0f);
        Vec3 directionToBoss = this.rhyza.m_146892_().m_82546_(player.m_146892_()).m_82541_();
        double dotProduct = playerLookVec.m_82526_(directionToBoss);
        if (hasLineOfSight && dotProduct > 0.5) {
            this.flashPlayer(player);
        }
    }

    private void flashPlayer(ServerPlayer player) {
        if (!(player.m_5833_() || player.m_7500_() || RhyzaSetBonusEvents.isFullSetWorn((Player)player))) {
            this.playersToBlind.add(player);
            ModNetwork.sendToPlayer(new FlashbangSequencePacket(), player);
            ModNetwork.sendToPlayer(new SoundPacket(((SoundEvent)ModSounds.RHYZA_FLASHBANG_RING.get()).m_11660_(), true), player);
        }
    }

    public static enum Phase {
        LEFT,
        RIGHT;

    }
}

